package com.thebeastshop.es.dao;

import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by gensheng.ye on 2021/10/26.
 */
public class EsUtil {
    protected final static Logger log = LoggerFactory.getLogger(EsUtil.class);

    public static boolean bulk(RestHighLevelClient client, BulkRequest bulkRequest,String methodName,String idOrCode){
//        log.info("methodName={}",methodName);
        BulkResponse bulkResponse = null;
        try {
            bulkResponse = client.bulk(bulkRequest);
            if (bulkResponse.hasFailures()) {
                log.error("methodName={},es_return_fail:{}" ,methodName, bulkResponse.buildFailureMessage());
            }else{
                return true;
            }
        } catch (Exception e) {
            log.error("methodName={},es_error:{}",methodName, e);
        }
        return false;
    }
}
