package com.thebeastshop.es.dao;

import com.thebeastshop.es.annotation.EsDaoConfig;
import com.thebeastshop.es.dao.core.AbstractEsDao;
import com.thebeastshop.es.spring.ElasticsearchFactoryBean;
import com.thebeastshop.scm.es.PsAttributeValuePairVO;
import com.thebeastshop.scm.es.PsCampaignVO;
import com.thebeastshop.scm.es.PsProductVO;
import com.thebeastshop.scm.es.PsSpvVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;


/**
 * @author gongjun[dt_flys@hotmail.com]
 * @since 2016-11-14 22:19
 */
@EsDaoConfig(id = "id", type = "pubcampaign")
public class CampaignEsDao extends AbstractEsDao<PsCampaignVO> {

    @Autowired
    public CampaignEsDao(ElasticsearchFactoryBean elasticsearchFactoryBean) {
        super(elasticsearchFactoryBean);
    }

    public void batchSave(List<PsCampaignVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = client.prepareBulk();
        for (PsCampaignVO vo : list) {
            Map<String, Object> sourceMap = vo.toMap();
            String id = MapUtils.getString(sourceMap, this.id);
            if (this.byId(id) == null) {
                IndexRequest indexRequest = this.getIndexRequest(id, sourceMap);
                bulkRequest.add(indexRequest);
            } else {
                UpdateRequest updateRequest = this.getUpdateRequest(id, sourceMap);
                bulkRequest.add(updateRequest);
            }
        }
        bulkRequest.execute().actionGet();

    }


    @Override
    public Map<String, Object> toMap(PsCampaignVO psCampaignVO) {
        return super.toMap(psCampaignVO);
    }

    @Override
    public PsCampaignVO toBean(Map<String, Object> sourceMap) {
        PsCampaignVO psCampaignVO = new PsCampaignVO();
        psCampaignVO.setId(MapUtils.getLong(sourceMap, "id"));
        psCampaignVO.setCrossBorderFlag(MapUtils.getInteger(sourceMap, "crossBorderFlag"));
        psCampaignVO.setDiscountTypeId(MapUtils.getInteger(sourceMap, "discountTypeId"));
        psCampaignVO.setName(MapUtils.getString(sourceMap, "name"));
        return psCampaignVO;
    }
}
