/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.weixin.service;

import com.thebeastshop.weixin.mapper.WxItemsMapper;
import com.thebeastshop.weixin.mapper.WxMaterialMapper;
import com.thebeastshop.weixin.mapper.WxSubscibeReplyMapper;
import com.thebeastshop.weixin.po.WxItems;
import com.thebeastshop.weixin.po.WxItemsExample;
import com.thebeastshop.weixin.po.WxMaterial;
import com.thebeastshop.weixin.po.WxSubscibeReply;
import com.thebeastshop.weixin.po.WxSubscibeReplyExample;
import com.thebeastshop.weixin.service.ServiceReplyService;
import com.thebeastshop.weixin.vo.ItemVO;
import com.thebeastshop.weixin.vo.MaterialVO;
import com.thebeastshop.weixin.vo.ReplyVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class SubscibeReplyService {
    @Autowired
    WxSubscibeReplyMapper wxSubscibeReplyMapper;
    @Autowired
    WxMaterialMapper wxMaterialMapper;
    @Autowired
    WxItemsMapper wxItemsMapper;
    private static final Logger logger = LoggerFactory.getLogger(ServiceReplyService.class);

    public int saveNewCutsomReply(WxSubscibeReply record) {
        logger.info("save autoreply for new custom.");
        int i = 0;
        WxSubscibeReply online = new WxSubscibeReply();
        WxSubscibeReplyExample example = new WxSubscibeReplyExample();
        online.setStatus(2);
        example.createCriteria().andIsValidEqualTo(true).andStatusEqualTo(1).andTypeEqualTo("custom");
        int offline = this.wxSubscibeReplyMapper.updateByExampleSelective(online, example);
        if (offline > 0) {
            WxSubscibeReply reply = new WxSubscibeReply();
            reply.setContent(record.getContent());
            reply.setContentType(record.getContentType());
            reply.setCreateTime(new Date());
            reply.setModifyTime(new Date());
            reply.setIsValid(true);
            reply.setMaterialId(record.getMaterialId());
            reply.setStatus(1);
            reply.setMediaId(record.getMediaId());
            reply.setType(record.getType());
            reply.setUrl(record.getUrl());
            i = this.wxSubscibeReplyMapper.insert(reply);
        }
        return i;
    }

    public ReplyVO getNewCustomReply() {
        logger.info("get autoreply for new custom.");
        ReplyVO newReply = new ReplyVO();
        WxSubscibeReplyExample example = new WxSubscibeReplyExample();
        example.createCriteria().andIsValidEqualTo(true).andTypeEqualTo("custom").andStatusEqualTo(1);
        example.setOrderByClause("modify_time desc");
        List<WxSubscibeReply> list = this.wxSubscibeReplyMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            WxSubscibeReply reply = list.get(0);
            if ("img-text".equals(reply.getContentType())) {
                Long materialId = reply.getMaterialId();
                MaterialVO materialvo = new MaterialVO();
                WxMaterial material = this.wxMaterialMapper.selectByPrimaryKey(materialId);
                if (null != material) {
                    materialvo.setCreateTime(material.getModifyTime());
                    materialvo.setId(materialId);
                    materialvo.setModifyTime(material.getModifyTime());
                    materialvo.setName(material.getName());
                    WxItemsExample wxItemsExample = new WxItemsExample();
                    wxItemsExample.createCriteria().andIsValidEqualTo(true).andMaterialIdEqualTo(materialId);
                    wxItemsExample.setOrderByClause("sort_no asc");
                    List<WxItems> items = this.wxItemsMapper.selectByExample(wxItemsExample);
                    if (CollectionUtils.isNotEmpty(items)) {
                        ArrayList<ItemVO> itemsvo = new ArrayList<ItemVO>();
                        for (WxItems item : items) {
                            ItemVO itemvo = new ItemVO();
                            itemvo.setDescription(item.getDescription());
                            itemvo.setId(item.getId());
                            itemvo.setMaterialId(materialId);
                            itemvo.setPicurl(item.getPicurl());
                            itemvo.setSortNo(item.getSortNo());
                            itemvo.setTitle(item.getTitle());
                            itemvo.setUrl(item.getUrl());
                            itemvo.setWeixinUrl(item.getWeixinUrl());
                            itemsvo.add(itemvo);
                        }
                        materialvo.setItems(itemsvo);
                    }
                    newReply.setMaterial(materialvo);
                    newReply.setMaterialId(materialId);
                    newReply.setContentType("img-text");
                }
            }
            newReply.setContent(reply.getContent());
            newReply.setContentType(reply.getContentType());
            newReply.setCreateTime(reply.getCreateTime());
            newReply.setId(reply.getId());
            newReply.setMediaId(reply.getMediaId());
            newReply.setModifyTime(reply.getModifyTime());
            newReply.setType(reply.getType());
            newReply.setUrl(reply.getUrl());
        }
        return newReply;
    }

    public int saveTextReply(WxSubscibeReply record) {
        logger.info("save autoreply for text.");
        int i = 0;
        WxSubscibeReply online = new WxSubscibeReply();
        WxSubscibeReplyExample example = new WxSubscibeReplyExample();
        online.setStatus(2);
        example.createCriteria().andIsValidEqualTo(true).andStatusEqualTo(1).andTypeEqualTo("auto");
        int offline = this.wxSubscibeReplyMapper.updateByExampleSelective(online, example);
        if (offline > 0) {
            WxSubscibeReply reply = new WxSubscibeReply();
            reply.setContent(record.getContent());
            reply.setContentType(record.getContentType());
            reply.setCreateTime(new Date());
            reply.setModifyTime(new Date());
            reply.setIsValid(true);
            reply.setMaterialId(record.getMaterialId());
            reply.setStatus(1);
            reply.setMediaId(record.getMediaId());
            reply.setType(record.getType());
            reply.setUrl(record.getUrl());
            i = this.wxSubscibeReplyMapper.insert(reply);
        }
        return i;
    }

    public ReplyVO getTextReply() {
        logger.info("get autoreply for text.");
        ReplyVO newReply = new ReplyVO();
        WxSubscibeReplyExample example = new WxSubscibeReplyExample();
        example.createCriteria().andIsValidEqualTo(true).andTypeEqualTo("auto").andStatusEqualTo(1);
        example.setOrderByClause("modify_time desc");
        List<WxSubscibeReply> list = this.wxSubscibeReplyMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            WxSubscibeReply reply = list.get(0);
            if ("img-text".equals(reply.getContentType())) {
                Long materialId = reply.getMaterialId();
                MaterialVO materialvo = new MaterialVO();
                WxMaterial material = this.wxMaterialMapper.selectByPrimaryKey(materialId);
                if (null != material) {
                    materialvo.setCreateTime(material.getModifyTime());
                    materialvo.setId(materialId);
                    materialvo.setModifyTime(material.getModifyTime());
                    materialvo.setName(material.getName());
                    WxItemsExample wxItemsExample = new WxItemsExample();
                    example.createCriteria().andIsValidEqualTo(true).andMaterialIdEqualTo(materialId);
                    example.setOrderByClause("sort_no asc");
                    List<WxItems> items = this.wxItemsMapper.selectByExample(wxItemsExample);
                    if (CollectionUtils.isNotEmpty(items)) {
                        ArrayList<ItemVO> itemsvo = new ArrayList<ItemVO>();
                        for (WxItems item : items) {
                            ItemVO itemvo = new ItemVO();
                            itemvo.setDescription(item.getDescription());
                            itemvo.setId(item.getId());
                            itemvo.setMaterialId(materialId);
                            itemvo.setPicurl(item.getPicurl());
                            itemvo.setSortNo(item.getSortNo());
                            itemvo.setTitle(item.getTitle());
                            itemvo.setUrl(item.getUrl());
                            itemvo.setWeixinUrl(item.getWeixinUrl());
                            itemsvo.add(itemvo);
                        }
                        materialvo.setItems(itemsvo);
                    }
                    newReply.setMaterial(materialvo);
                    newReply.setMaterialId(materialId);
                }
            }
            newReply.setContent(reply.getContent());
            newReply.setContentType(reply.getContentType());
            newReply.setCreateTime(reply.getCreateTime());
            newReply.setId(reply.getId());
            newReply.setMediaId(reply.getMediaId());
            newReply.setModifyTime(reply.getModifyTime());
            newReply.setType(reply.getType());
            newReply.setUrl(reply.getUrl());
        }
        return newReply;
    }

    public int deleteKeywordReply(long id) {
        logger.info("delete autoreply for keyword.");
        WxSubscibeReply record = new WxSubscibeReply();
        WxSubscibeReplyExample example = new WxSubscibeReplyExample();
        record.setStatus(4);
        example.createCriteria().andIsValidEqualTo(true).andStatusEqualTo(1).andTypeEqualTo("keyword").andIdEqualTo(id);
        int i = this.wxSubscibeReplyMapper.updateByExampleSelective(record, example);
        return i;
    }

    public Long insertKeywordReply(WxSubscibeReply record) {
        logger.info("insert autoreply for keyword.");
        Long i = 0L;
        WxSubscibeReplyExample example = new WxSubscibeReplyExample();
        example.createCriteria().andIsValidEqualTo(true).andStatusEqualTo(1).andTypeEqualTo("keyword").andKeywordsEqualTo(record.getKeywords());
        List<WxSubscibeReply> online = this.wxSubscibeReplyMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(online)) {
            return -99L;
        }
        WxSubscibeReply reply = new WxSubscibeReply();
        reply.setContent(record.getContent());
        reply.setContentType(record.getContentType());
        reply.setKeywords(record.getKeywords());
        reply.setMatchMode(record.getMatchMode());
        reply.setCreateTime(new Date());
        reply.setModifyTime(new Date());
        reply.setIsValid(true);
        reply.setMaterialId(record.getMaterialId());
        reply.setStatus(1);
        reply.setMediaId(record.getMediaId());
        reply.setType(record.getType());
        reply.setUrl(record.getUrl());
        this.wxSubscibeReplyMapper.insert(reply);
        i = reply.getId();
        return i;
    }

    public int updateKeywordReply(WxSubscibeReply record) {
        logger.info("update autoreply for keyword.");
        WxSubscibeReplyExample example = new WxSubscibeReplyExample();
        example.createCriteria().andIsValidEqualTo(true).andStatusEqualTo(1).andTypeEqualTo("keyword").andKeywordsEqualTo(record.getKeywords());
        List<WxSubscibeReply> hasList = this.wxSubscibeReplyMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(hasList)) {
            for (WxSubscibeReply has : hasList) {
                if (has.getId() == record.getId()) continue;
                return -99;
            }
        }
        int update = this.wxSubscibeReplyMapper.updateByPrimaryKeySelective(record);
        return update;
    }

    public List<ReplyVO> getKeywordReplyList(int currPage, @RequestParam int pageSize) {
        logger.info("get autoreply for keyword.");
        ArrayList<ReplyVO> replys = new ArrayList<ReplyVO>();
        List<WxSubscibeReply> list = this.wxSubscibeReplyMapper.selectByExampleWithLimit(currPage, pageSize);
        if (CollectionUtils.isNotEmpty(list)) {
            for (WxSubscibeReply reply : list) {
                ReplyVO keywordReply = new ReplyVO();
                if ("img-text".equals(reply.getContentType())) {
                    Long materialId = reply.getMaterialId();
                    MaterialVO materialvo = new MaterialVO();
                    WxMaterial material = this.wxMaterialMapper.selectByPrimaryKey(materialId);
                    if (null != material) {
                        materialvo.setCreateTime(material.getModifyTime());
                        materialvo.setId(materialId);
                        materialvo.setModifyTime(material.getModifyTime());
                        materialvo.setName(material.getName());
                        WxItemsExample wxItemsExample = new WxItemsExample();
                        wxItemsExample.createCriteria().andIsValidEqualTo(true).andMaterialIdEqualTo(materialId);
                        wxItemsExample.setOrderByClause("sort_no asc");
                        List<WxItems> items = this.wxItemsMapper.selectByExample(wxItemsExample);
                        if (CollectionUtils.isNotEmpty(items)) {
                            ArrayList<ItemVO> itemsvo = new ArrayList<ItemVO>();
                            for (WxItems item : items) {
                                ItemVO itemvo = new ItemVO();
                                itemvo.setDescription(item.getDescription());
                                itemvo.setId(item.getId());
                                itemvo.setMaterialId(materialId);
                                itemvo.setPicurl(item.getPicurl());
                                itemvo.setSortNo(item.getSortNo());
                                itemvo.setTitle(item.getTitle());
                                itemvo.setUrl(item.getUrl());
                                itemvo.setWeixinUrl(item.getWeixinUrl());
                                itemsvo.add(itemvo);
                            }
                            materialvo.setItems(itemsvo);
                        }
                        keywordReply.setMaterial(materialvo);
                        keywordReply.setMaterialId(materialId);
                    }
                }
                keywordReply.setContent(reply.getContent());
                keywordReply.setContentType(reply.getContentType());
                keywordReply.setCreateTime(reply.getCreateTime());
                keywordReply.setId(reply.getId());
                keywordReply.setMediaId(reply.getMediaId());
                keywordReply.setModifyTime(reply.getModifyTime());
                keywordReply.setType(reply.getType());
                keywordReply.setUrl(reply.getUrl());
                replys.add(keywordReply);
            }
        }
        return replys;
    }

    public ReplyVO getKeywordReplyById(Long id) {
        logger.info("get autoreply for keyword by id.");
        ReplyVO keywordReply = new ReplyVO();
        WxSubscibeReplyExample example = new WxSubscibeReplyExample();
        example.createCriteria().andIsValidEqualTo(true).andTypeEqualTo("keyword").andStatusEqualTo(1);
        example.setOrderByClause("modify_time desc");
        List<WxSubscibeReply> list = this.wxSubscibeReplyMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            WxSubscibeReply reply = list.get(0);
            if ("img-text".equals(reply.getContentType())) {
                Long materialId = reply.getMaterialId();
                MaterialVO materialvo = new MaterialVO();
                WxMaterial material = this.wxMaterialMapper.selectByPrimaryKey(materialId);
                if (null != material) {
                    materialvo.setCreateTime(material.getModifyTime());
                    materialvo.setId(materialId);
                    materialvo.setModifyTime(material.getModifyTime());
                    materialvo.setName(material.getName());
                    WxItemsExample wxItemsExample = new WxItemsExample();
                    example.createCriteria().andIsValidEqualTo(true).andMaterialIdEqualTo(materialId);
                    example.setOrderByClause("sort_no asc");
                    List<WxItems> items = this.wxItemsMapper.selectByExample(wxItemsExample);
                    if (CollectionUtils.isNotEmpty(items)) {
                        ArrayList<ItemVO> itemsvo = new ArrayList<ItemVO>();
                        for (WxItems item : items) {
                            ItemVO itemvo = new ItemVO();
                            itemvo.setDescription(item.getDescription());
                            itemvo.setId(item.getId());
                            itemvo.setMaterialId(materialId);
                            itemvo.setPicurl(item.getPicurl());
                            itemvo.setSortNo(item.getSortNo());
                            itemvo.setTitle(item.getTitle());
                            itemvo.setUrl(item.getUrl());
                            itemvo.setWeixinUrl(item.getWeixinUrl());
                            itemsvo.add(itemvo);
                        }
                        materialvo.setItems(itemsvo);
                    }
                    keywordReply.setMaterial(materialvo);
                    keywordReply.setMaterialId(materialId);
                }
            }
            keywordReply.setContent(reply.getContent());
            keywordReply.setContentType(reply.getContentType());
            keywordReply.setCreateTime(reply.getCreateTime());
            keywordReply.setId(reply.getId());
            keywordReply.setMediaId(reply.getMediaId());
            keywordReply.setModifyTime(reply.getModifyTime());
            keywordReply.setType(reply.getType());
            keywordReply.setUrl(reply.getUrl());
        }
        return keywordReply;
    }

    public ReplyVO getKeywordReply(String keyword) {
        logger.info("get autoreply for keywordnews.");
        ReplyVO keywordReply = new ReplyVO();
        WxSubscibeReplyExample example = new WxSubscibeReplyExample();
        example.createCriteria().andIsValidEqualTo(true).andTypeEqualTo("keyword").andStatusEqualTo(1).andKeywordsEqualTo(keyword);
        example.setOrderByClause("modify_time desc");
        List<WxSubscibeReply> list = this.wxSubscibeReplyMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            WxSubscibeReply reply = list.get(0);
            if ("img-text".equals(reply.getContentType())) {
                Long materialId = reply.getMaterialId();
                MaterialVO materialvo = new MaterialVO();
                WxMaterial material = this.wxMaterialMapper.selectByPrimaryKey(materialId);
                if (null != material) {
                    materialvo.setCreateTime(material.getModifyTime());
                    materialvo.setId(materialId);
                    materialvo.setModifyTime(material.getModifyTime());
                    materialvo.setName(material.getName());
                    WxItemsExample wxItemsExample = new WxItemsExample();
                    example.createCriteria().andIsValidEqualTo(true).andMaterialIdEqualTo(materialId);
                    example.setOrderByClause("sort_no asc");
                    List<WxItems> items = this.wxItemsMapper.selectByExample(wxItemsExample);
                    if (CollectionUtils.isNotEmpty(items)) {
                        ArrayList<ItemVO> itemsvo = new ArrayList<ItemVO>();
                        for (WxItems item : items) {
                            ItemVO itemvo = new ItemVO();
                            itemvo.setDescription(item.getDescription());
                            itemvo.setId(item.getId());
                            itemvo.setMaterialId(materialId);
                            itemvo.setPicurl(item.getPicurl());
                            itemvo.setSortNo(item.getSortNo());
                            itemvo.setTitle(item.getTitle());
                            itemvo.setUrl(item.getUrl());
                            itemvo.setWeixinUrl(item.getWeixinUrl());
                            itemsvo.add(itemvo);
                        }
                        materialvo.setItems(itemsvo);
                    }
                    keywordReply.setMaterial(materialvo);
                    keywordReply.setMaterialId(materialId);
                }
            }
            keywordReply.setContent(reply.getContent());
            keywordReply.setContentType(reply.getContentType());
            keywordReply.setCreateTime(reply.getCreateTime());
            keywordReply.setId(reply.getId());
            keywordReply.setMediaId(reply.getMediaId());
            keywordReply.setModifyTime(reply.getModifyTime());
            keywordReply.setType(reply.getType());
            keywordReply.setUrl(reply.getUrl());
        }
        return keywordReply;
    }
}

