/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.weixin.service;

import com.thebeastshop.weixin.mapper.WxItemsMapper;
import com.thebeastshop.weixin.mapper.WxMaterialMapper;
import com.thebeastshop.weixin.mapper.WxSubscibeMenuMapper;
import com.thebeastshop.weixin.mapper.WxSubscibeReplyMapper;
import com.thebeastshop.weixin.po.WxItems;
import com.thebeastshop.weixin.po.WxItemsExample;
import com.thebeastshop.weixin.po.WxMaterial;
import com.thebeastshop.weixin.po.WxSubscibeMenu;
import com.thebeastshop.weixin.po.WxSubscibeMenuExample;
import com.thebeastshop.weixin.po.WxSubscibeReply;
import com.thebeastshop.weixin.service.ServiceReplyService;
import com.thebeastshop.weixin.vo.ItemVO;
import com.thebeastshop.weixin.vo.KeywordVO;
import com.thebeastshop.weixin.vo.MaterialVO;
import com.thebeastshop.weixin.vo.MenuDetailsVO;
import com.thebeastshop.weixin.vo.MenuVO;
import com.thebeastshop.weixin.vo.MenuWeixinVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubscibeMenuService {
    @Autowired
    WxSubscibeMenuMapper wxSubscibeMenuMapper;
    @Autowired
    WxMaterialMapper wxMaterialMapper;
    @Autowired
    WxSubscibeReplyMapper wxSubscibeReplyMapper;
    @Autowired
    WxItemsMapper wxItemsMapper;
    private static final Logger logger = LoggerFactory.getLogger(ServiceReplyService.class);
    private int limit1 = 3;
    private int limit2 = 5;

    public Long saveMenu(MenuDetailsVO menu) {
        logger.info("save new menu.");
        long i = 0L;
        long parentId = 0L;
        int limit = this.limit1;
        if (null != menu.getParentId() && 0L != (parentId = menu.getParentId().longValue())) {
            limit = this.limit2;
        }
        WxSubscibeMenuExample example = new WxSubscibeMenuExample();
        example.createCriteria().andIsValidEqualTo(true).andStatusEqualTo(1).andParentIdEqualTo(parentId);
        List<WxSubscibeMenu> menuList = this.wxSubscibeMenuMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(menuList) && menuList.size() >= limit) {
            return -99L;
        }
        if ("message".equals(menu.getResponseType())) {
            logger.info("insert autoreply for keyword.");
            KeywordVO key = menu.getKey();
            String keyWord = "key-" + parentId + "-" + System.currentTimeMillis();
            WxSubscibeReply reply = new WxSubscibeReply();
            reply.setContent(key.getContent());
            reply.setContentType(key.getContentType());
            reply.setKeywords(keyWord);
            reply.setMatchMode(key.getMatchMode());
            reply.setCreateTime(new Date());
            reply.setModifyTime(new Date());
            reply.setIsValid(true);
            reply.setMaterialId(key.getMaterialId());
            reply.setStatus(1);
            reply.setMediaId(key.getMediaId());
            reply.setType("keyword");
            reply.setUrl(key.getUrl());
            int keywordId = this.wxSubscibeReplyMapper.insert(reply);
            WxSubscibeMenu record = new WxSubscibeMenu();
            record.setCreateTime(new Date());
            record.setIsValid(true);
            record.setKeyword(keyWord);
            record.setKeywordId(Long.valueOf(keywordId));
            record.setModifyTime(new Date());
            record.setName(menu.getName());
            record.setParentId(parentId);
            record.setResponseType("message");
            record.setSortNo(menu.getSortNo());
            record.setStatus(1);
            this.wxSubscibeMenuMapper.insert(record);
            i = record.getId();
        } else {
            WxSubscibeMenu record = new WxSubscibeMenu();
            record.setCreateTime(new Date());
            record.setIsValid(true);
            record.setModifyTime(new Date());
            record.setName(menu.getName());
            record.setParentId(parentId);
            record.setResponseType("url");
            record.setResponseUrl(menu.getResponseUrl());
            record.setSortNo(menu.getSortNo());
            record.setStatus(1);
            this.wxSubscibeMenuMapper.insert(record);
            i = record.getId();
        }
        return i;
    }

    public int updateMenu(MenuDetailsVO menu) {
        logger.info("update menu.");
        int i = 0;
        long parentId = 0L;
        if (null != menu.getParentId()) {
            parentId = menu.getParentId();
        }
        if ("message".equals(menu.getResponseType())) {
            WxSubscibeReply reply;
            KeywordVO key = menu.getKey();
            long keywordId = 0L;
            String keyWord = "";
            if (null != menu.getKeywordId() && null != menu.getKeyword() && !"".equals(menu.getKeyword())) {
                keywordId = menu.getKeywordId();
                keyWord = menu.getKeyword();
                reply = new WxSubscibeReply();
                reply.setContent(key.getContent());
                reply.setContentType(key.getContentType());
                reply.setId(key.getId());
                reply.setIsValid(true);
                reply.setKeywords(key.getKeywords());
                reply.setMatchMode(key.getMatchMode());
                reply.setMaterialId(key.getMaterialId());
                reply.setMediaId(key.getMediaId());
                reply.setModifyTime(new Date());
                reply.setStatus(1);
                reply.setType("keyword");
                reply.setUrl(key.getUrl());
                this.wxSubscibeReplyMapper.updateByPrimaryKeySelective(reply);
            } else {
                keyWord = "key-" + parentId + "-" + System.currentTimeMillis();
                reply = new WxSubscibeReply();
                reply.setContent(key.getContent());
                reply.setContentType(key.getContentType());
                reply.setKeywords(keyWord);
                reply.setMatchMode(key.getMatchMode());
                reply.setCreateTime(new Date());
                reply.setModifyTime(new Date());
                reply.setIsValid(true);
                reply.setMaterialId(key.getMaterialId());
                reply.setStatus(1);
                reply.setMediaId(key.getMediaId());
                reply.setType("keyword");
                reply.setUrl(key.getUrl());
                keywordId = this.wxSubscibeReplyMapper.insert(reply);
            }
            WxSubscibeMenu record = new WxSubscibeMenu();
            record.setIsValid(true);
            record.setKeyword(keyWord);
            record.setKeywordId(keywordId);
            record.setModifyTime(new Date());
            record.setName(menu.getName());
            record.setParentId(parentId);
            record.setResponseType("message");
            record.setId(menu.getId());
            record.setSortNo(menu.getSortNo());
            record.setStatus(1);
            i = this.wxSubscibeMenuMapper.updateByPrimaryKeySelective(record);
        } else {
            WxSubscibeMenu record = new WxSubscibeMenu();
            record.setIsValid(true);
            record.setModifyTime(new Date());
            record.setName(menu.getName());
            record.setParentId(parentId);
            record.setResponseType("url");
            record.setId(menu.getId());
            record.setResponseUrl(menu.getResponseUrl());
            record.setSortNo(menu.getSortNo());
            record.setStatus(1);
            i = this.wxSubscibeMenuMapper.updateByPrimaryKeySelective(record);
        }
        return i;
    }

    public int deleteMenu(long id) {
        logger.info("delete menu.");
        int i = 0;
        WxSubscibeMenu record = new WxSubscibeMenu();
        record.setStatus(4);
        record.setId(id);
        i = this.wxSubscibeMenuMapper.updateByPrimaryKeySelective(record);
        return i;
    }

    public MenuDetailsVO getMenuDetailsById(long id) {
        logger.info("get menu details by id.");
        MenuDetailsVO menuVO = new MenuDetailsVO();
        WxSubscibeMenu menu = this.wxSubscibeMenuMapper.selectByPrimaryKey(id);
        if (menu.getStatus() == 1) {
            WxSubscibeMenuExample example = new WxSubscibeMenuExample();
            example.createCriteria().andStatusEqualTo(1).andIsValidEqualTo(true).andParentIdEqualTo(id);
            List<WxSubscibeMenu> sonMenu = this.wxSubscibeMenuMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(sonMenu) && sonMenu.size() > 0) {
                menuVO.setId(id);
                menuVO.setIsLeaf(false);
                menuVO.setName(menu.getName());
                menuVO.setSortNo(menu.getSortNo());
                return menuVO;
            }
            if ("message".equals(menu.getResponseType())) {
                KeywordVO keywordVO = new KeywordVO();
                WxSubscibeReply key = this.wxSubscibeReplyMapper.selectByPrimaryKey(menu.getKeywordId());
                if (key.getStatus() == 1 && "keyword".equals(key.getType())) {
                    if ("img-text".equals(key.getContentType())) {
                        Long materialId = key.getMaterialId();
                        MaterialVO materialvo = new MaterialVO();
                        WxMaterial material = this.wxMaterialMapper.selectByPrimaryKey(materialId);
                        if (null != material) {
                            materialvo.setCreateTime(material.getModifyTime());
                            materialvo.setId(materialId);
                            materialvo.setModifyTime(material.getModifyTime());
                            materialvo.setName(material.getName());
                            WxItemsExample wxItemsExample = new WxItemsExample();
                            wxItemsExample.createCriteria().andIsValidEqualTo(true).andMaterialIdEqualTo(materialId);
                            wxItemsExample.setOrderByClause("sort_no asc");
                            List<WxItems> items = this.wxItemsMapper.selectByExample(wxItemsExample);
                            if (CollectionUtils.isNotEmpty(items)) {
                                ArrayList<ItemVO> itemsvo = new ArrayList<ItemVO>();
                                for (WxItems item : items) {
                                    ItemVO itemvo = new ItemVO();
                                    itemvo.setDescription(item.getDescription());
                                    itemvo.setId(item.getId());
                                    itemvo.setMaterialId(materialId);
                                    itemvo.setPicurl(item.getPicurl());
                                    itemvo.setSortNo(item.getSortNo());
                                    itemvo.setTitle(item.getTitle());
                                    itemvo.setUrl(item.getUrl());
                                    itemvo.setWeixinUrl(item.getWeixinUrl());
                                    itemsvo.add(itemvo);
                                }
                                materialvo.setItems(itemsvo);
                            }
                            keywordVO.setMaterial(materialvo);
                            keywordVO.setMaterialId(materialId);
                        }
                    } else {
                        keywordVO.setContent(key.getContent());
                        keywordVO.setContentType(key.getContentType());
                        keywordVO.setId(key.getId());
                        keywordVO.setKeywords(key.getKeywords());
                        keywordVO.setMatchMode(key.getMatchMode());
                        keywordVO.setUrl(key.getUrl());
                    }
                }
                menuVO.setCreateTime(menu.getCreateTime());
                menuVO.setId(id);
                menuVO.setIsLeaf(true);
                menuVO.setModifyTime(menu.getModifyTime());
                menuVO.setName(menu.getName());
                menuVO.setParentId(menu.getParentId());
                menuVO.setResponseType("message");
                menuVO.setKeyword(menu.getKeyword());
                menuVO.setKeywordId(menu.getKeywordId());
                menuVO.setKey(keywordVO);
            } else {
                menuVO.setCreateTime(menu.getCreateTime());
                menuVO.setId(id);
                menuVO.setIsLeaf(true);
                menuVO.setModifyTime(menu.getModifyTime());
                menuVO.setName(menu.getName());
                menuVO.setParentId(menu.getParentId());
                menuVO.setResponseType("url");
                menuVO.setResponseUrl(menu.getResponseUrl());
            }
        } else {
            return null;
        }
        return menuVO;
    }

    public List<MenuVO> getMenuList() {
        logger.info("get all menus.");
        ArrayList<MenuVO> menuList = new ArrayList<MenuVO>();
        WxSubscibeMenuExample example = new WxSubscibeMenuExample();
        example.createCriteria().andStatusEqualTo(1).andIsValidEqualTo(true).andParentIdEqualTo(0L);
        example.setOrderByClause("sort_no asc");
        List<WxSubscibeMenu> wxServiceMenus = this.wxSubscibeMenuMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(wxServiceMenus)) {
            for (WxSubscibeMenu wxServiceMen : wxServiceMenus) {
                MenuVO menu = new MenuVO();
                menu.setId(wxServiceMen.getId());
                menu.setName(wxServiceMen.getName());
                menu.setParentId(wxServiceMen.getParentId());
                menu.setSortNo(wxServiceMen.getSortNo());
                WxSubscibeMenuExample subexample = new WxSubscibeMenuExample();
                subexample.createCriteria().andStatusEqualTo(1).andIsValidEqualTo(true).andParentIdEqualTo(wxServiceMen.getParentId());
                subexample.setOrderByClause("sort_no asc");
                List<WxSubscibeMenu> subWxServiceMenus = this.wxSubscibeMenuMapper.selectByExample(subexample);
                if (CollectionUtils.isNotEmpty(subWxServiceMenus)) {
                    ArrayList<MenuVO> subMenus = new ArrayList<MenuVO>();
                    for (WxSubscibeMenu subWxServiceMenu : subWxServiceMenus) {
                        MenuVO subMenu = new MenuVO();
                        subMenu.setId(subWxServiceMenu.getId());
                        subMenu.setName(subWxServiceMenu.getName());
                        subMenu.setParentId(subWxServiceMenu.getParentId());
                        subMenu.setSortNo(subWxServiceMenu.getSortNo());
                        subMenus.add(subMenu);
                    }
                    menu.setSubMenus(subMenus);
                }
                menuList.add(menu);
            }
        }
        return menuList;
    }

    public List<MenuWeixinVO> getWeixinMenuList() {
        logger.info("get all menus for weixin.");
        ArrayList<MenuWeixinVO> menuList = new ArrayList<MenuWeixinVO>();
        WxSubscibeMenuExample example = new WxSubscibeMenuExample();
        example.createCriteria().andStatusEqualTo(1).andIsValidEqualTo(true).andParentIdEqualTo(0L);
        example.setOrderByClause("sort_no asc");
        List<WxSubscibeMenu> wxServiceMenus = this.wxSubscibeMenuMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(wxServiceMenus)) {
            for (WxSubscibeMenu wxServiceMen : wxServiceMenus) {
                MenuWeixinVO menu = new MenuWeixinVO();
                menu.setId(wxServiceMen.getId());
                menu.setName(wxServiceMen.getName());
                menu.setType(wxServiceMen.getResponseType());
                menu.setKeyword(wxServiceMen.getKeyword());
                menu.setUrl(wxServiceMen.getResponseUrl());
                menu.setSortNo(wxServiceMen.getSortNo());
                WxSubscibeMenuExample subexample = new WxSubscibeMenuExample();
                subexample.createCriteria().andStatusEqualTo(1).andIsValidEqualTo(true).andParentIdEqualTo(wxServiceMen.getParentId());
                subexample.setOrderByClause("sort_no asc");
                List<WxSubscibeMenu> subWxServiceMenus = this.wxSubscibeMenuMapper.selectByExample(subexample);
                if (CollectionUtils.isNotEmpty(subWxServiceMenus)) {
                    ArrayList<MenuWeixinVO> subMenus = new ArrayList<MenuWeixinVO>();
                    for (WxSubscibeMenu subWxServiceMenu : subWxServiceMenus) {
                        MenuWeixinVO subMenu = new MenuWeixinVO();
                        subMenu.setId(subWxServiceMenu.getId());
                        subMenu.setName(subWxServiceMenu.getName());
                        subMenu.setSortNo(subWxServiceMenu.getSortNo());
                        subMenu.setKeyword(subWxServiceMenu.getKeyword());
                        subMenu.setType(subWxServiceMenu.getResponseType());
                        subMenu.setUrl(subWxServiceMenu.getResponseUrl());
                        subMenus.add(subMenu);
                    }
                    menu.setSubMenus(subMenus);
                }
                menuList.add(menu);
            }
        }
        return menuList;
    }
}

