/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.weixin.service;

import com.thebeastshop.weixin.mapper.WxItemsMapper;
import com.thebeastshop.weixin.mapper.WxMaterialMapper;
import com.thebeastshop.weixin.po.WxItems;
import com.thebeastshop.weixin.po.WxItemsExample;
import com.thebeastshop.weixin.po.WxMaterial;
import com.thebeastshop.weixin.service.ServiceReplyService;
import com.thebeastshop.weixin.vo.ItemVO;
import com.thebeastshop.weixin.vo.MaterialVO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaterialService {
    @Autowired
    WxMaterialMapper wxMaterialMapper;
    @Autowired
    WxItemsMapper wxItemsMapper;
    private static final Logger logger = LoggerFactory.getLogger(ServiceReplyService.class);

    public Long insertMaterial(WxMaterial record, List<WxItems> items) {
        logger.info("insert material.");
        int i = this.wxMaterialMapper.insert(record);
        if (i > 0) {
            logger.info("\u63d2\u5165\u4e3b\u8868\u6210\u529f recordId={}", (Object)record.getId());
            int sort = 1;
            if (CollectionUtils.isNotEmpty(items)) {
                logger.info("\u5b50\u6570\u636e\u4e0d\u4e3a\u7a7a\uff0c\u63d2\u5165\u7d20\u6750\u5e93\u5b50\u8868\u4e2d recordId={}", (Object)record.getId());
                for (WxItems item : items) {
                    logger.info("\u63d2\u5165\u7d20\u6750\u5e93\u5b50\u8868\uff0csort={}", (Object)sort);
                    item.setMaterialId(record.getId());
                    item.setSortNo(sort);
                    this.wxItemsMapper.insert(item);
                    ++sort;
                }
            }
        }
        return record.getId();
    }

    public int updateMaterial(WxMaterial record, List<WxItems> items) {
        logger.info("update material.");
        int result = this.wxMaterialMapper.updateByPrimaryKeySelective(record);
        if (result > 0) {
            WxItemsExample examp = new WxItemsExample();
            examp.createCriteria().andIsValidEqualTo(true).andMaterialIdEqualTo(record.getId());
            int i = this.wxItemsMapper.deleteByExample(examp);
            for (WxItems item : items) {
                this.wxItemsMapper.insert(item);
            }
        }
        return result;
    }

    public int deleteMaterialById(long id) {
        logger.info("delete material by id.");
        int i = this.wxMaterialMapper.deleteByPrimaryKey(id);
        if (i > 0) {
            WxItemsExample example = new WxItemsExample();
            example.createCriteria().andIsValidEqualTo(true).andMaterialIdEqualTo(id);
            this.wxItemsMapper.deleteByExample(example);
        }
        return i;
    }

    public MaterialVO getMaterialById(Long id) {
        logger.info("get material by id.");
        MaterialVO materialvo = new MaterialVO();
        WxMaterial material = this.wxMaterialMapper.selectByPrimaryKey(id);
        if (null != material) {
            materialvo.setCreateTime(material.getModifyTime());
            materialvo.setId(id);
            materialvo.setModifyTime(material.getModifyTime());
            materialvo.setName(material.getName());
            WxItemsExample example = new WxItemsExample();
            example.createCriteria().andIsValidEqualTo(true).andMaterialIdEqualTo(id);
            example.setOrderByClause("sort_no asc");
            List<WxItems> items = this.wxItemsMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(items)) {
                ArrayList<ItemVO> itemsvo = new ArrayList<ItemVO>();
                for (WxItems item : items) {
                    ItemVO itemvo = new ItemVO();
                    itemvo.setDescription(item.getDescription());
                    itemvo.setId(item.getId());
                    itemvo.setMaterialId(id);
                    itemvo.setPicurl(item.getPicurl());
                    itemvo.setSortNo(item.getSortNo());
                    itemvo.setTitle(item.getTitle());
                    itemvo.setUrl(item.getUrl());
                    itemvo.setWeixinUrl(item.getWeixinUrl());
                    itemsvo.add(itemvo);
                }
                materialvo.setItems(itemsvo);
            }
        }
        return materialvo;
    }

    public List<WxMaterial> getMaterialList(int currPage, int pageSize) {
        logger.info("get material list.");
        ArrayList<WxMaterial> materialList = new ArrayList();
        materialList = this.wxMaterialMapper.selectByExampleWithLimit(currPage, pageSize);
        return materialList;
    }

    public List<ItemVO> getMaterialDetailsById(Long materialId) {
        logger.info("get material details by material id.");
        WxItemsExample example = new WxItemsExample();
        example.createCriteria().andIsValidEqualTo(true).andMaterialIdEqualTo(materialId);
        example.setOrderByClause("sort_no asc");
        ArrayList<ItemVO> itemsvo = new ArrayList<ItemVO>();
        List<WxItems> items = this.wxItemsMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(items)) {
            for (WxItems item : items) {
                ItemVO itemvo = new ItemVO();
                itemvo.setDescription(item.getDescription());
                itemvo.setId(item.getId());
                itemvo.setMaterialId(materialId);
                itemvo.setPicurl(item.getPicurl());
                itemvo.setSortNo(item.getSortNo());
                itemvo.setTitle(item.getTitle());
                itemvo.setUrl(item.getUrl());
                itemvo.setWeixinUrl(item.getWeixinUrl());
                itemsvo.add(itemvo);
            }
        }
        return itemsvo;
    }
}

