/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.weixin.global;

import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.AccessToken;
import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.cache.IAccessTokenCache;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.RetryUtils;
import com.thebeastshop.weixin.controller.MassController;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenCompanyApi {
    private static final Logger logger = LoggerFactory.getLogger(MassController.class);
    private static String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=ID&corpsecret=SECRET";

    public static AccessToken getAccessToken() {
        ApiConfig ac = ApiConfigKit.getApiConfig();
        AccessToken result = AccessTokenCompanyApi.getAvailableAccessToken(ac);
        if (result != null) {
            return result;
        }
        return AccessTokenCompanyApi.refreshAccessTokenIfNecessary(ac);
    }

    private static AccessToken getAvailableAccessToken(ApiConfig ac) {
        AccessToken result;
        IAccessTokenCache accessTokenCache = ApiConfigKit.getAccessTokenCache();
        String accessTokenJson = accessTokenCache.get(ac.getAppSecret());
        if (StrKit.notBlank((String)accessTokenJson) && (result = new AccessToken(accessTokenJson)) != null && result.isAvailable()) {
            return result;
        }
        return null;
    }

    public static String getAccessTokenStr() {
        return AccessTokenCompanyApi.getAccessToken().getAccessToken();
    }

    private static synchronized AccessToken refreshAccessTokenIfNecessary(ApiConfig ac) {
        AccessToken result = AccessTokenCompanyApi.getAvailableAccessToken(ac);
        if (result != null) {
            return result;
        }
        return AccessTokenCompanyApi.refreshAccessToken(ac);
    }

    public static AccessToken refreshAccessToken() {
        return AccessTokenCompanyApi.refreshAccessToken(ApiConfigKit.getApiConfig());
    }

    public static AccessToken refreshAccessToken(ApiConfig ac) {
        String corpid = ac.getAppId();
        String corpsecret = ac.getAppSecret();
        logger.info("\u66f4\u65b0token\uff1acorpid={},corpsecret={},url={}", new Object[]{corpid, corpsecret, url});
        final String requestUrl = url.replace("ID", corpid).replace("SECRET", corpsecret);
        logger.info("\u8bf7\u6c42\u5730\u5740 requestUrl = {}", (Object)requestUrl);
        AccessToken result = (AccessToken)RetryUtils.retryOnException((int)3, (Callable)new Callable<AccessToken>(){

            @Override
            public AccessToken call() throws Exception {
                String json = HttpUtils.get((String)requestUrl);
                logger.info("json={}", (Object)json);
                return new AccessToken(json);
            }
        });
        if (null != result) {
            IAccessTokenCache accessTokenCache = ApiConfigKit.getAccessTokenCache();
            accessTokenCache.set(ac.getAppSecret(), result.getCacheJson());
        }
        return result;
    }
}

