/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.weixin.controller.service;

import com.jfinal.kit.StrKit;
import com.jfinal.weixin.iot.msg.InEquDataMsg;
import com.jfinal.weixin.iot.msg.InEqubindEvent;
import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.encrypt.AesException;
import com.jfinal.weixin.sdk.encrypt.WXBizMsgCrypt;
import com.jfinal.weixin.sdk.jfinal.MsgController;
import com.jfinal.weixin.sdk.msg.in.InImageMsg;
import com.jfinal.weixin.sdk.msg.in.InLinkMsg;
import com.jfinal.weixin.sdk.msg.in.InLocationMsg;
import com.jfinal.weixin.sdk.msg.in.InMsg;
import com.jfinal.weixin.sdk.msg.in.InNotDefinedMsg;
import com.jfinal.weixin.sdk.msg.in.InShortVideoMsg;
import com.jfinal.weixin.sdk.msg.in.InTextMsg;
import com.jfinal.weixin.sdk.msg.in.InVideoMsg;
import com.jfinal.weixin.sdk.msg.in.InVoiceMsg;
import com.jfinal.weixin.sdk.msg.in.card.InCardPassCheckEvent;
import com.jfinal.weixin.sdk.msg.in.card.InCardPayOrderEvent;
import com.jfinal.weixin.sdk.msg.in.card.InCardSkuRemindEvent;
import com.jfinal.weixin.sdk.msg.in.card.InMerChantOrderEvent;
import com.jfinal.weixin.sdk.msg.in.card.InUpdateMemberCardEvent;
import com.jfinal.weixin.sdk.msg.in.card.InUserCardEvent;
import com.jfinal.weixin.sdk.msg.in.card.InUserConsumeCardEvent;
import com.jfinal.weixin.sdk.msg.in.card.InUserGetCardEvent;
import com.jfinal.weixin.sdk.msg.in.card.InUserGiftingCardEvent;
import com.jfinal.weixin.sdk.msg.in.card.InUserPayFromCardEvent;
import com.jfinal.weixin.sdk.msg.in.event.InCustomEvent;
import com.jfinal.weixin.sdk.msg.in.event.InFollowEvent;
import com.jfinal.weixin.sdk.msg.in.event.InLocationEvent;
import com.jfinal.weixin.sdk.msg.in.event.InMassEvent;
import com.jfinal.weixin.sdk.msg.in.event.InMenuEvent;
import com.jfinal.weixin.sdk.msg.in.event.InNotDefinedEvent;
import com.jfinal.weixin.sdk.msg.in.event.InPoiCheckNotifyEvent;
import com.jfinal.weixin.sdk.msg.in.event.InQrCodeEvent;
import com.jfinal.weixin.sdk.msg.in.event.InShakearoundUserShakeEvent;
import com.jfinal.weixin.sdk.msg.in.event.InTemplateMsgEvent;
import com.jfinal.weixin.sdk.msg.in.event.InVerifyFailEvent;
import com.jfinal.weixin.sdk.msg.in.event.InVerifySuccessEvent;
import com.jfinal.weixin.sdk.msg.in.event.InWifiEvent;
import com.jfinal.weixin.sdk.msg.in.speech_recognition.InSpeechRecognitionResults;
import com.jfinal.weixin.sdk.msg.out.News;
import com.jfinal.weixin.sdk.msg.out.OutImageMsg;
import com.jfinal.weixin.sdk.msg.out.OutMsg;
import com.jfinal.weixin.sdk.msg.out.OutNewsMsg;
import com.jfinal.weixin.sdk.msg.out.OutTextMsg;
import com.jfinal.weixin.sdk.msg.out.OutVideoMsg;
import com.jfinal.weixin.sdk.msg.out.OutVoiceMsg;
import com.thebeastshop.weixin.enums.ErrorCode;
import com.thebeastshop.weixin.enums.ResponseFormat;
import com.thebeastshop.weixin.global.ErrorInfo;
import com.thebeastshop.weixin.global.ResponseResult;
import com.thebeastshop.weixin.po.WxMassLog;
import com.thebeastshop.weixin.po.WxServiceReply;
import com.thebeastshop.weixin.service.MassLogService;
import com.thebeastshop.weixin.service.ServiceReplyService;
import com.thebeastshop.weixin.utils.CheckUtils;
import com.thebeastshop.weixin.vo.ItemVO;
import com.thebeastshop.weixin.vo.ReplyVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@RestController
@Api(description="\u670d\u52a1\u53f7\u81ea\u52a8\u56de\u590d\u7c7b")
@RequestMapping(value={"service_reply"})
public class ReplyServiceController
extends MsgController {
    private static final Logger logger = LoggerFactory.getLogger(ReplyServiceController.class);
    @Autowired
    ServiceReplyService serviceReplyService;
    @Autowired
    MassLogService massLogService;

    public ApiConfig getApiConfig() {
        ApiConfig ac = new ApiConfig();
        ac.setToken("9527_token");
        ac.setAppId("wx579f341b7607ca1d");
        ac.setAppSecret("d800ede5f53f847b4e675ade30dfd403");
        ac.setEncryptMessage(false);
        ac.setEncodingAesKey("testkey");
        logger.info("\u914d\u7f6e\u5fae\u4fe1\u76f8\u5173\u5e38\u91cf");
        return ac;
    }

    @ApiOperation(value="\u83b7\u53d6\u65b0\u7528\u6237\u81ea\u52a8\u56de\u590d\u5185\u5bb9")
    @GetMapping(value={"getNewCustomReply"})
    public ResponseResult<ReplyVO> getNewCustomReply() {
        try {
            ResponseResult<ReplyVO> resp = new ResponseResult<ReplyVO>();
            ReplyVO newCustomReply = this.serviceReplyService.getNewCustomReply();
            resp.setData(newCustomReply);
            resp.setSuccess(true);
            return resp;
        }
        catch (Exception e) {
            logger.error("get reply for new custom. ", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u65b0\u7528\u6237\u81ea\u52a8\u56de\u590d")
    @PostMapping(value={"saveNewReply"})
    public ResponseResult<Integer> saveNewReply(@RequestBody ReplyVO reply) {
        try {
            ResponseResult<Integer> resp = new ResponseResult<Integer>();
            resp.setSuccess(false);
            WxServiceReply record = new WxServiceReply();
            record.setContent(reply.getContent());
            record.setContentType(reply.getContentType());
            record.setMaterialId(reply.getMaterialId());
            record.setMediaId(reply.getMediaId());
            record.setType("custom");
            record.setUrl(reply.getUrl());
            int newCustomReply = this.serviceReplyService.saveNewCutsomReply(record);
            if (newCustomReply > 0) {
                resp.setData(newCustomReply);
                resp.setSuccess(true);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("save reply for new custom. ", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u6d88\u606f\u81ea\u52a8\u56de\u590d")
    @PostMapping(value={"saveAutoReply"})
    public ResponseResult<Integer> saveAutoReply(@RequestBody ReplyVO reply) {
        try {
            ResponseResult<Integer> resp = new ResponseResult<Integer>();
            resp.setSuccess(false);
            WxServiceReply record = new WxServiceReply();
            record.setContent(reply.getContent());
            record.setContentType(reply.getContentType());
            record.setMaterialId(reply.getMaterialId());
            record.setMediaId(reply.getMediaId());
            record.setType("auto");
            record.setUrl(reply.getUrl());
            int textReply = this.serviceReplyService.saveTextReply(record);
            if (textReply > 0) {
                resp.setData(textReply);
                resp.setSuccess(true);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("save auto reply.", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6d88\u606f\u81ea\u52a8\u56de\u590d")
    @GetMapping(value={"getAutoReply"})
    public ResponseResult<ReplyVO> getTextReply() {
        try {
            ResponseResult<ReplyVO> resp = new ResponseResult<ReplyVO>();
            ReplyVO textReply = this.serviceReplyService.getTextReply();
            resp.setData(textReply);
            resp.setSuccess(true);
            return resp;
        }
        catch (Exception e) {
            logger.error("save auto reply.", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u5220\u9664\u5173\u952e\u5b57\u56de\u590d")
    @GetMapping(value={"deleteKeywordReply"})
    public ResponseResult<Boolean> deleteKeywordReply(@RequestParam long id) {
        try {
            ResponseResult<Boolean> resp = new ResponseResult<Boolean>();
            resp.setData(false);
            int i = this.serviceReplyService.deleteKeywordReply(id);
            if (i > 0) {
                // empty if block
            }
            resp.setData(true);
            resp.setSuccess(true);
            return resp;
        }
        catch (Exception e) {
            logger.error("delete reply for keyword.", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u65b0\u589e\u5173\u952e\u5b57\u56de\u590d")
    @PostMapping(value={"insertKeywordReply"})
    public ResponseResult<Long> insertKeywordReply(@RequestBody ReplyVO reply) {
        try {
            ResponseResult<Long> resp = new ResponseResult<Long>();
            resp.setSuccess(false);
            WxServiceReply record = new WxServiceReply();
            record.setContent(reply.getContent());
            record.setContentType(reply.getContentType());
            record.setKeywords(reply.getKeywords());
            if (null != reply.getMatchMode() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reply.getMatchMode()})) {
                record.setMatchMode(reply.getMatchMode());
            } else {
                record.setMatchMode("equals");
            }
            record.setMaterialId(reply.getMaterialId());
            record.setMediaId(reply.getMediaId());
            record.setType("keyword");
            record.setUrl(reply.getUrl());
            Long keywordReply = this.serviceReplyService.insertKeywordReply(record);
            if (keywordReply > 0L) {
                resp.setData(keywordReply);
                resp.setSuccess(true);
            } else if (keywordReply == -99L) {
                ErrorInfo errorInfo = new ErrorInfo();
                errorInfo.setCode(ErrorCode.KEYWORDS_REPEAT.getCode());
                ArrayList<String> errorMessageList = new ArrayList<String>();
                errorMessageList.add(ErrorCode.KEYWORDS_REPEAT.getName());
                errorInfo.setErrorMessageList(errorMessageList);
                resp.setErrorInfo(errorInfo);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("save reply for keyword.", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u7f16\u8f91\u5173\u952e\u5b57")
    @PostMapping(value={"updateKeywordReply"})
    public ResponseResult<Boolean> updateKeywordReply(@RequestBody ReplyVO vo) {
        try {
            ResponseResult<Boolean> resp = new ResponseResult<Boolean>();
            resp.setSuccess(false);
            WxServiceReply record = new WxServiceReply();
            record.setContent(vo.getContent());
            record.setContentType(vo.getContentType());
            record.setKeywords(vo.getKeywords());
            record.setMatchMode(vo.getMatchMode());
            record.setMaterialId(vo.getMaterialId());
            record.setMediaId(vo.getMediaId());
            record.setType("keyword");
            record.setModifyTime(new Date());
            record.setStatus(1);
            record.setUrl(vo.getUrl());
            record.setId(vo.getId());
            int keywordReply = this.serviceReplyService.updateKeywordReply(record);
            if (keywordReply > 0) {
                resp.setData(true);
                resp.setSuccess(true);
            } else if (keywordReply == -99) {
                ErrorInfo errorInfo = new ErrorInfo();
                errorInfo.setCode(ErrorCode.KEYWORDS_REPEAT.getCode());
                ArrayList<String> errorMessageList = new ArrayList<String>();
                errorMessageList.add(ErrorCode.KEYWORDS_REPEAT.getName());
                errorInfo.setErrorMessageList(errorMessageList);
                resp.setErrorInfo(errorInfo);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("update reply for keyword.", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u5173\u952e\u5b57\u56de\u590d\u5217\u8868")
    @GetMapping(value={"getKeywordReplyList"})
    public ResponseResult<List<ReplyVO>> getKeywordReplyList(@RequestParam int currPage, @RequestParam int pageSize) {
        try {
            ResponseResult<List<ReplyVO>> resp = new ResponseResult<List<ReplyVO>>();
            List<ReplyVO> keywordReplys = this.serviceReplyService.getKeywordReplyList(currPage, pageSize);
            if (CollectionUtils.isNotEmpty(keywordReplys)) {
                resp.setData(keywordReplys);
                resp.setSuccess(true);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("get all reply for keyword.", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u6839\u636e\u5173\u952e\u5b57id\u83b7\u53d6\u5173\u952e\u5b57\u8be6\u60c5")
    @GetMapping(value={"getKeywordReplyById"})
    public ResponseResult<ReplyVO> getKeywordReplyById(@RequestParam Long keyword) {
        try {
            ResponseResult<ReplyVO> resp = new ResponseResult<ReplyVO>();
            ReplyVO reply = this.serviceReplyService.getKeywordReplyById(keyword);
            if (null != reply) {
                resp.setData(reply);
                resp.setSuccess(true);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("get reply for keyword by id.", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="token\u9a8c\u8bc1")
    @GetMapping(value={""})
    public String check(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        logger.info("\u5fae\u4fe1\u9a8c\u8bc1\u53c2\u6570 signature={},timestamp={},nonce={},echostr={}", new Object[]{signature, timestamp, nonce, echostr});
        if (signature != null && CheckUtils.checkSignature(signature, timestamp, nonce)) {
            logger.info("success");
            return echostr;
        }
        return echostr;
    }

    @ApiOperation(value="token\u9a8c\u8bc1")
    @PostMapping(value={""})
    public String returntest(HttpServletRequest request, HttpServletResponse response) throws IOException, AesException, ParserConfigurationException, SAXException {
        int n;
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String msg_signature = request.getParameter("msg_signature");
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = request.getInputStream().read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        String encryptMsg = out.toString();
        logger.info("\u5fae\u4fe1\u9a8c\u8bc1\u53c2\u6570 signature={},timestamp={},nonce={},msg_signature={}\uff0cencryptMsg={}", new Object[]{signature, timestamp, nonce, msg_signature, encryptMsg});
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        StringReader sr = new StringReader(encryptMsg);
        InputSource is = new InputSource(sr);
        Document document = db.parse(is);
        Element root = document.getDocumentElement();
        NodeList nodelist1 = root.getElementsByTagName("Encrypt");
        NodeList nodelist3 = root.getElementsByTagName("MsgType");
        NodeList nodelist4 = root.getElementsByTagName("Content");
        String encrypt = nodelist1.item(0).getTextContent();
        String MesgType = nodelist3.item(0).getTextContent();
        String content = nodelist4.item(0).getTextContent();
        logger.info("xml\u89e3\u6790\u5185\u5bb9 encrypt={},MesgType={},content={}", new Object[]{encrypt, MesgType, content});
        String format = "<xml><ToUserName><![CDATA[toUser]]></ToUserName><Encrypt><![CDATA[%1$s]]></Encrypt></xml>";
        switch (MesgType) {
            case "text": {
                format = ResponseFormat.TEXT.getFormat();
                break;
            }
            case "image": {
                format = ResponseFormat.IMAGE.getFormat();
                break;
            }
            case "voice": {
                format = ResponseFormat.VOICE.getFormat();
                break;
            }
            case "video": {
                format = ResponseFormat.VIDEO.getFormat();
                break;
            }
            case "music": {
                format = ResponseFormat.MUSIC.getFormat();
                break;
            }
            case "news": {
                format = ResponseFormat.NEWS.getFormat();
            }
        }
        String fromXML = String.format(format, encrypt);
        logger.info("\u8fd4\u56de  fromXML={} : " + fromXML);
        String encodingAesKey = "";
        String token = "9527_token";
        String appId = "wx579f341b7607ca1d";
        WXBizMsgCrypt pc = new WXBizMsgCrypt(token, encodingAesKey, appId);
        String result2 = pc.decryptMsg(msg_signature, timestamp, nonce, fromXML);
        logger.info("result2 = {}", (Object)result2);
        return result2;
    }

    protected void processInTextMsg(InTextMsg inTextMsg) {
        logger.info("processInTextMsg start");
        String msgContent = inTextMsg.getContent().trim();
        logger.info("msgContent ===" + msgContent);
        ReplyVO keyword = this.serviceReplyService.getKeywordReply(msgContent);
        if (keyword != null) {
            if ("text".equals(keyword.getContentType())) {
                OutTextMsg outMsg = new OutTextMsg((InMsg)inTextMsg);
                outMsg.setContent(keyword.getContent());
                this.render((OutMsg)outMsg);
            } else if ("pic".equals(keyword.getContentType())) {
                OutImageMsg outMsg = new OutImageMsg((InMsg)inTextMsg);
                outMsg.setMediaId(keyword.getMediaId());
                this.render((OutMsg)outMsg);
            } else if ("voice".equals(keyword.getContentType())) {
                OutVoiceMsg outMsg = new OutVoiceMsg((InMsg)inTextMsg);
                outMsg.setMediaId(keyword.getMediaId());
                this.render((OutMsg)outMsg);
            } else if ("video".equals(keyword.getContentType())) {
                OutVideoMsg outMsg = new OutVideoMsg((InMsg)inTextMsg);
                outMsg.setMediaId(keyword.getMediaId());
                this.render((OutMsg)outMsg);
            } else if ("img-text".equals(keyword.getContentType())) {
                OutNewsMsg outMsg = new OutNewsMsg((InMsg)inTextMsg);
                if (null != keyword.getMaterial() && CollectionUtils.isNotEmpty(keyword.getMaterial().getItems())) {
                    ArrayList<News> items = new ArrayList<News>();
                    for (ItemVO item : keyword.getMaterial().getItems()) {
                        News news = new News();
                        news.setDescription(item.getDescription());
                        news.setTitle(item.getTitle());
                        news.setPicUrl(item.getPicurl());
                        news.setUrl(item.getUrl());
                        items.add(news);
                    }
                    outMsg.setArticles(items);
                    this.render((OutMsg)outMsg);
                }
            }
        } else {
            this.renderNull();
            return;
        }
        logger.info("processInTextMsg end");
    }

    protected void processInImageMsg(InImageMsg inImageMsg) {
        logger.info("\u56fe\u7247\u6d88\u606f\u81ea\u52a8\u56de\u590d");
        OutTextMsg outMsg = new OutTextMsg((InMsg)inImageMsg);
        outMsg.setContent("\u7531\u4e8e\u8d44\u8be2\u91cf\u8fc7\u5927\uff0c\u8bf7\u5c3d\u91cf\u4f7f\u7528\u6587\u5b57\u8be2\u95ee!");
        this.render((OutMsg)outMsg);
    }

    protected void processInVoiceMsg(InVoiceMsg inVoiceMsg) {
        logger.info("\u8bed\u97f3\u6d88\u606f\u81ea\u52a8\u56de\u590d");
        OutTextMsg outMsg = new OutTextMsg((InMsg)inVoiceMsg);
        outMsg.setContent("\u7531\u4e8e\u8d44\u8be2\u91cf\u8fc7\u5927\uff0c\u8bf7\u5c3d\u91cf\u4f7f\u7528\u6587\u5b57\u8be2\u95ee!");
        this.render((OutMsg)outMsg);
    }

    protected void processInVideoMsg(InVideoMsg inVideoMsg) {
        logger.info("\u89c6\u9891\u6d88\u606f\u81ea\u52a8\u56de\u590d");
        OutTextMsg outMsg = new OutTextMsg((InMsg)inVideoMsg);
        outMsg.setContent("\u7531\u4e8e\u8d44\u8be2\u91cf\u8fc7\u5927\uff0c\u8bf7\u5c3d\u91cf\u4f7f\u7528\u6587\u5b57\u8be2\u95ee!");
        this.render((OutMsg)outMsg);
    }

    protected void processInShortVideoMsg(InShortVideoMsg inShortVideoMsg) {
        logger.info("\u5c0f\u89c6\u9891\u6d88\u606f\u81ea\u52a8\u56de\u590d");
        OutTextMsg outMsg = new OutTextMsg((InMsg)inShortVideoMsg);
        outMsg.setContent("\u7531\u4e8e\u8d44\u8be2\u91cf\u8fc7\u5927\uff0c\u8bf7\u5c3d\u91cf\u4f7f\u7528\u6587\u5b57\u8be2\u95ee!");
        this.render((OutMsg)outMsg);
    }

    protected void processInLocationMsg(InLocationMsg inLocationMsg) {
        logger.info("\u4f4d\u7f6e\u6d88\u606f\u81ea\u52a8\u56de\u590d");
        OutTextMsg outMsg = new OutTextMsg((InMsg)inLocationMsg);
        outMsg.setContent("\u7531\u4e8e\u8d44\u8be2\u91cf\u8fc7\u5927\uff0c\u8bf7\u5c3d\u91cf\u4f7f\u7528\u6587\u5b57\u8be2\u95ee!");
        this.render((OutMsg)outMsg);
    }

    protected void processInLinkMsg(InLinkMsg inLinkMsg) {
        logger.info("\u94fe\u63a5\u6d88\u606f\u81ea\u52a8\u56de\u590d");
        OutTextMsg outMsg = new OutTextMsg((InMsg)inLinkMsg);
        outMsg.setContent("\u7531\u4e8e\u8d44\u8be2\u91cf\u8fc7\u5927\uff0c\u8bf7\u5c3d\u91cf\u4f7f\u7528\u6587\u5b57\u8be2\u95ee!");
        this.render((OutMsg)outMsg);
    }

    protected void processInCustomEvent(InCustomEvent inCustomEvent) {
    }

    protected void processInFollowEvent(InFollowEvent inFollowEvent) {
        if ("subscribe".equals(inFollowEvent.getEvent())) {
            logger.debug("\u5173\u6ce8\uff1a" + inFollowEvent.getFromUserName());
            OutTextMsg outMsg = new OutTextMsg((InMsg)inFollowEvent);
            ReplyVO newCustomReply = this.serviceReplyService.getNewCustomReply();
            outMsg.setContent(newCustomReply.getContent());
            this.render((OutMsg)outMsg);
        } else if ("unsubscribe".equals(inFollowEvent.getEvent())) {
            logger.info("\u53d6\u6d88\u5173\u6ce8\uff1a" + inFollowEvent.getFromUserName());
            this.renderNull();
        }
    }

    protected void processInQrCodeEvent(InQrCodeEvent inQrCodeEvent) {
    }

    protected void processInLocationEvent(InLocationEvent inLocationEvent) {
    }

    protected void processInMassEvent(InMassEvent inMassEvent) {
        WxMassLog wxMassLog = new WxMassLog();
        wxMassLog.setContent(inMassEvent.getEvent());
        wxMassLog.setErrorcount(Integer.parseInt(inMassEvent.getErrorCount()));
        wxMassLog.setFiltercount(Integer.parseInt(inMassEvent.getFilterCount()));
        wxMassLog.setIsValid(true);
        wxMassLog.setMsgid(inMassEvent.getMsgId());
        wxMassLog.setSentcount(Integer.parseInt(inMassEvent.getSentCount()));
        wxMassLog.setSentTime(new Date());
        wxMassLog.setStatus(1);
        wxMassLog.setTotalcount(Integer.parseInt(inMassEvent.getTotalCount()));
        wxMassLog.setType(inMassEvent.getMsgType());
        this.massLogService.insertMassLog(wxMassLog);
    }

    protected void processInMenuEvent(InMenuEvent inMenuEvent) {
        String eventKey = inMenuEvent.getEventKey();
        logger.info("\u70b9\u51fbmenu\u4e8b\u4ef6\u5bf9\u5e94\u7684keyword" + eventKey);
        if ("VIEW".equals(inMenuEvent.getEvent())) {
            OutTextMsg outMsg = new OutTextMsg((InMsg)inMenuEvent);
            outMsg.setMsgType("view");
            outMsg.setContent(eventKey);
            this.render((OutMsg)outMsg);
            return;
        }
        if (!StrKit.isBlank((String)eventKey)) {
            ReplyVO keyword = this.serviceReplyService.getKeywordReply(eventKey);
            if (keyword != null) {
                if ("text".equals(keyword.getContentType())) {
                    OutTextMsg outMsg = new OutTextMsg((InMsg)inMenuEvent);
                    outMsg.setContent(keyword.getContent());
                    this.render((OutMsg)outMsg);
                } else if ("pic".equals(keyword.getContentType())) {
                    OutImageMsg outMsg = new OutImageMsg((InMsg)inMenuEvent);
                    outMsg.setMediaId(keyword.getMediaId());
                    this.render((OutMsg)outMsg);
                } else if ("voice".equals(keyword.getContentType())) {
                    OutVoiceMsg outMsg = new OutVoiceMsg((InMsg)inMenuEvent);
                    outMsg.setMediaId(keyword.getMediaId());
                    this.render((OutMsg)outMsg);
                } else if ("video".equals(keyword.getContentType())) {
                    OutVideoMsg outMsg = new OutVideoMsg((InMsg)inMenuEvent);
                    outMsg.setMediaId(keyword.getMediaId());
                    this.render((OutMsg)outMsg);
                } else if ("img-text".equals(keyword.getContentType())) {
                    OutNewsMsg outMsg = new OutNewsMsg((InMsg)inMenuEvent);
                    if (null != keyword.getMaterial() && CollectionUtils.isNotEmpty(keyword.getMaterial().getItems())) {
                        ArrayList<News> items = new ArrayList<News>();
                        for (ItemVO item : keyword.getMaterial().getItems()) {
                            News news = new News();
                            news.setDescription(item.getDescription());
                            news.setTitle(item.getTitle());
                            news.setPicUrl(item.getPicurl());
                            news.setUrl(item.getUrl());
                            items.add(news);
                        }
                        outMsg.setArticles(items);
                        this.render((OutMsg)outMsg);
                    }
                }
            } else {
                OutTextMsg outMsg = new OutTextMsg((InMsg)inMenuEvent);
                ReplyVO textReply = this.serviceReplyService.getTextReply();
                outMsg.setContent(textReply.getContent());
                this.render((OutMsg)outMsg);
            }
        }
    }

    protected void processInSpeechRecognitionResults(InSpeechRecognitionResults inSpeechRecognitionResults) {
    }

    protected void processInTemplateMsgEvent(InTemplateMsgEvent inTemplateMsgEvent) {
    }

    protected void processInShakearoundUserShakeEvent(InShakearoundUserShakeEvent inShakearoundUserShakeEvent) {
    }

    protected void processInVerifySuccessEvent(InVerifySuccessEvent inVerifySuccessEvent) {
    }

    protected void processInVerifyFailEvent(InVerifyFailEvent inVerifyFailEvent) {
    }

    protected void processInPoiCheckNotifyEvent(InPoiCheckNotifyEvent inPoiCheckNotifyEvent) {
    }

    protected void processInWifiEvent(InWifiEvent inWifiEvent) {
    }

    protected void processInUserCardEvent(InUserCardEvent inUserCardEvent) {
    }

    protected void processInUpdateMemberCardEvent(InUpdateMemberCardEvent inUpdateMemberCardEvent) {
    }

    protected void processInUserPayFromCardEvent(InUserPayFromCardEvent inUserPayFromCardEvent) {
    }

    protected void processInMerChantOrderEvent(InMerChantOrderEvent inMerChantOrderEvent) {
    }

    protected void processIsNotDefinedEvent(InNotDefinedEvent inNotDefinedEvent) {
    }

    protected void processIsNotDefinedMsg(InNotDefinedMsg inNotDefinedMsg) {
    }

    protected void processInUserGiftingCardEvent(InUserGiftingCardEvent msg) {
    }

    protected void processInUserGetCardEvent(InUserGetCardEvent msg) {
    }

    protected void processInUserConsumeCardEvent(InUserConsumeCardEvent msg) {
    }

    protected void processInCardSkuRemindEvent(InCardSkuRemindEvent msg) {
    }

    protected void processInCardPayOrderEvent(InCardPayOrderEvent msg) {
    }

    protected void processInCardPassCheckEvent(InCardPassCheckEvent msg) {
    }

    protected void processInEqubindEvent(InEqubindEvent msg) {
    }

    protected void processInEquDataMsg(InEquDataMsg msg) {
    }
}

