/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.weixin.controller.service;

import com.jfinal.kit.PropKit;
import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.api.MenuApi;
import com.jfinal.weixin.sdk.jfinal.ApiController;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.weixin.adapter.MenuAdapter;
import com.thebeastshop.weixin.enums.ErrorCode;
import com.thebeastshop.weixin.global.ErrorInfo;
import com.thebeastshop.weixin.global.ResponseResult;
import com.thebeastshop.weixin.service.ServiceMenuService;
import com.thebeastshop.weixin.vo.MenuDetailsVO;
import com.thebeastshop.weixin.vo.MenuVO;
import com.thebeastshop.weixin.vo.MenuWeixinVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="\u670d\u52a1\u53f7\u83dc\u5355\u7c7b")
@RequestMapping(value={"service_menu"})
public class MenuServiceController
extends ApiController {
    private static final Logger logger = LoggerFactory.getLogger(MenuServiceController.class);
    @Autowired
    ServiceMenuService serviceMenuService;
    @Autowired
    MenuAdapter menuAdapter;

    public ApiConfig getApiConfig() {
        ApiConfig ac = new ApiConfig();
        PropKit.use((String)"params.properties");
        String appid = PropKit.get((String)"service_appId");
        String token = PropKit.get((String)"service_token");
        String sercret = PropKit.get((String)"service_appSecret");
        ac.setToken(token);
        ac.setAppId(appid);
        ac.setAppSecret(sercret);
        ac.setEncryptMessage(false);
        ac.setEncodingAesKey("MVey8o5AonLZURTtCkbX3ur3nxe1eBBbXzS9jGsYF4W");
        return ac;
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u5217\u8868")
    @GetMapping(value={"getMenuList"})
    public ResponseResult<List<MenuVO>> getMenuList() {
        try {
            ResponseResult<List<MenuVO>> resp = new ResponseResult<List<MenuVO>>();
            List<MenuVO> menuList = this.serviceMenuService.getMenuList();
            if (CollectionUtils.isNotEmpty(menuList)) {
                resp.setData(menuList);
                resp.setSuccess(true);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("get menu list. ", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u76ee\u5f55")
    @GetMapping(value={"deleteMenuById"})
    public ResponseResult<Boolean> deleteMenuById(@RequestParam long id) {
        try {
            ResponseResult<Boolean> resp = new ResponseResult<Boolean>();
            resp.setData(false);
            int i = this.serviceMenuService.deleteMenu(id);
            if (i > 0) {
                // empty if block
            }
            resp.setData(true);
            resp.setSuccess(true);
            return resp;
        }
        catch (Exception e) {
            logger.error("delete menu by id.", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u65b0\u589e\u76ee\u5f55")
    @PostMapping(value={"addMenu"})
    public ResponseResult<Long> addMenu(@RequestBody MenuDetailsVO menu) {
        try {
            Long i;
            ResponseResult<Long> resp = new ResponseResult<Long>();
            resp.setSuccess(false);
            if (null == menu.getParentId()) {
                menu.setParentId(0L);
            }
            if ((i = this.serviceMenuService.saveMenu(menu)) > 0L) {
                resp.setData(i);
                resp.setSuccess(true);
            } else {
                logger.info("\u76ee\u5f55\u8d85\u8fc7\u6700\u5927\u6570");
                ErrorInfo errorInfo = new ErrorInfo();
                errorInfo.setCode(ErrorCode.MENU_EXCESS.getCode());
                ArrayList<String> errorMessageList = new ArrayList<String>();
                errorMessageList.add(ErrorCode.MENU_EXCESS.getName());
                errorInfo.setErrorMessageList(errorMessageList);
                resp.setErrorInfo(errorInfo);
                resp.setSuccess(false);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("add menu. ", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u7f16\u8f91\u76ee\u5f55")
    @PostMapping(value={"updateMenu"})
    public ResponseResult<Boolean> updateKeywordReply(@RequestBody MenuDetailsVO menu) {
        try {
            ResponseResult<Boolean> resp = new ResponseResult<Boolean>();
            resp.setSuccess(false);
            int keywordReply = this.serviceMenuService.updateMenu(menu);
            if (keywordReply > 0) {
                resp.setData(true);
                resp.setSuccess(true);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("update menu.", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u521b\u5efa\u83dc\u5355\u5230\u5fae\u4fe1")
    @GetMapping(value={"createMenu"})
    public ResponseResult<Boolean> createMenuToWeixin() {
        try {
            ResponseResult<Boolean> resp = new ResponseResult<Boolean>();
            this.createMenu();
            resp.setData(true);
            return resp;
        }
        catch (Exception e) {
            logger.error("get menu list. ", (Throwable)e);
            throw e;
        }
    }

    public void createMenu() {
        List<MenuWeixinVO> menuList = this.serviceMenuService.getWeixinMenuList();
        String jsonMenu = MenuAdapter.assembleMenu(menuList);
        ApiConfig ac = new ApiConfig();
        String appid = PropConstants.getProperties((String)"service_appId");
        String token = PropConstants.getProperties((String)"service_token");
        String sercret = PropConstants.getProperties((String)"service_appSecret");
        String encodingAesKey = PropConstants.getProperties((String)"service_encodingAesKey");
        logger.info("\u914d\u7f6e\u5fae\u4fe1api\u76f8\u5173\u5e38\u91cf appid={}\uff0ctoken={}\uff0csercre={}", new Object[]{appid, token, sercret});
        ac.setToken(token);
        ac.setAppId(appid);
        ac.setAppSecret(sercret);
        ac.setEncryptMessage(false);
        ac.setEncodingAesKey(encodingAesKey);
        ApiConfigKit.putApiConfig((ApiConfig)ac);
        ApiConfigKit.setThreadLocalAppId((String)appid);
        ApiResult apiResult = MenuApi.createMenu((String)jsonMenu);
        if (apiResult.isSucceed()) {
            logger.info("create menu successful");
        } else {
            logger.info("create menu is failed\uff01 error={},code={}", (Object)apiResult.getErrorMsg(), (Object)apiResult.getErrorCode());
        }
    }
}

