/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.weixin.controller;

import com.jfinal.weixin.sdk.jfinal.ApiController;
import com.thebeastshop.weixin.global.ResponseResult;
import com.thebeastshop.weixin.po.WxItems;
import com.thebeastshop.weixin.po.WxMaterial;
import com.thebeastshop.weixin.service.MaterialService;
import com.thebeastshop.weixin.vo.ItemVO;
import com.thebeastshop.weixin.vo.MaterialVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="\u7d20\u6750\u7c7b")
@RequestMapping(value={"material"})
public class MaterialController
extends ApiController {
    private static final Logger logger = LoggerFactory.getLogger(MaterialController.class);
    @Autowired
    MaterialService materialService;

    @ApiOperation(value="\u83b7\u53d6\u7d20\u6750\u5217\u8868")
    @GetMapping(value={"getMaterialList"})
    public ResponseResult<List<MaterialVO>> getMaterialList(@RequestParam int currPage, @RequestParam int pageSize) {
        logger.info("\u5206\u9875\u83b7\u53d6\u7d20\u6750\u5217\u8868\uff0ccurrPage={}\uff0cpageSize={}", (Object)currPage, (Object)pageSize);
        try {
            ResponseResult<List<MaterialVO>> resp = new ResponseResult<List<MaterialVO>>();
            ArrayList<MaterialVO> list = new ArrayList<MaterialVO>();
            List<WxMaterial> materialList = this.materialService.getMaterialList(currPage, pageSize);
            if (CollectionUtils.isNotEmpty(materialList)) {
                for (WxMaterial material : materialList) {
                    MaterialVO materialVO = new MaterialVO();
                    materialVO.setCreateTime(material.getCreateTime());
                    materialVO.setId(material.getId());
                    materialVO.setModifyTime(material.getModifyTime());
                    materialVO.setName(material.getName());
                    List<ItemVO> items = this.materialService.getMaterialDetailsById(material.getId());
                    materialVO.setItems(items);
                    list.add(materialVO);
                }
                resp.setData(list);
                resp.setSuccess(true);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("get material list. ", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u7d20\u6750")
    @GetMapping(value={"deleteMaterialById"})
    public ResponseResult<Boolean> deleteMaterialById(@RequestParam long id) {
        try {
            ResponseResult<Boolean> resp = new ResponseResult<Boolean>();
            resp.setData(false);
            int i = this.materialService.deleteMaterialById(id);
            if (i > 0) {
                // empty if block
            }
            resp.setData(true);
            resp.setSuccess(true);
            return resp;
        }
        catch (Exception e) {
            logger.error("delete material by id.", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u65b0\u589e\u7d20\u6750")
    @PostMapping(value={"addMaterial"})
    public ResponseResult<Long> addMaterial(@RequestBody MaterialVO material) {
        try {
            Long recordId;
            logger.info("\u65b0\u589e\u7d20\u6750\u53c2\u6570\uff1a\u7d20\u6750\u540d\u5b57name={}", (Object)material.getName());
            logger.info("\u65b0\u589e\u7d20\u6750\u53c2\u6570\u6570\u91cf\uff1aitemSize={}", (Object)material.getItems().size());
            ResponseResult<Long> resp = new ResponseResult<Long>();
            resp.setSuccess(false);
            WxMaterial record = new WxMaterial();
            ArrayList<WxItems> items = new ArrayList<WxItems>();
            record.setCreateTime(new Date());
            record.setIsValid(true);
            record.setModifyTime(new Date());
            record.setName(material.getName());
            record.setStatus(1);
            if (CollectionUtils.isNotEmpty(material.getItems())) {
                for (ItemVO itemVO : material.getItems()) {
                    WxItems item = new WxItems();
                    item.setCreateTime(new Date());
                    item.setDescription(itemVO.getDescription());
                    item.setIsValid(true);
                    item.setModifyTime(new Date());
                    item.setPicurl(itemVO.getPicurl());
                    item.setTitle(itemVO.getTitle());
                    item.setUrl(itemVO.getUrl());
                    item.setWeixinUrl(itemVO.getWeixinUrl());
                    items.add(item);
                    logger.info("\u65b0\u589e\u7d20\u6750item\u53c2\u6570\uff1adescription={},picurl={},title={},url={},weixinUril={}", new Object[]{itemVO.getDescription(), itemVO.getPicurl(), itemVO.getTitle(), itemVO.getUrl(), itemVO.getWeixinUrl()});
                }
            }
            if ((recordId = this.materialService.insertMaterial(record, items)) > 0L) {
                resp.setData(recordId);
                resp.setSuccess(true);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("add material. ", (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="\u7f16\u8f91\u7d20\u6750")
    @PostMapping(value={"updateMaterial"})
    public ResponseResult<Boolean> updateMaterial(@RequestBody MaterialVO material) {
        try {
            int i;
            ResponseResult<Boolean> resp = new ResponseResult<Boolean>();
            resp.setSuccess(false);
            WxMaterial record = new WxMaterial();
            ArrayList<WxItems> items = new ArrayList<WxItems>();
            record.setId(material.getId());
            record.setIsValid(true);
            record.setModifyTime(new Date());
            record.setName(material.getName());
            record.setStatus(1);
            if (CollectionUtils.isNotEmpty(material.getItems())) {
                for (ItemVO itemVO : material.getItems()) {
                    WxItems item = new WxItems();
                    item.setDescription(itemVO.getDescription());
                    item.setIsValid(true);
                    item.setModifyTime(new Date());
                    item.setPicurl(itemVO.getPicurl());
                    item.setTitle(itemVO.getTitle());
                    item.setUrl(itemVO.getUrl());
                    item.setId(itemVO.getId());
                    item.setWeixinUrl(itemVO.getWeixinUrl());
                    item.setSortNo(itemVO.getSortNo());
                    item.setMaterialId(record.getId());
                    items.add(item);
                }
            }
            if ((i = this.materialService.updateMaterial(record, items)) > 0) {
                resp.setData(true);
                resp.setSuccess(true);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("update material. ", (Throwable)e);
            throw e;
        }
    }
}

