/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.weixin.adapter;

import com.jfinal.kit.JsonKit;
import com.thebeastshop.weixin.vo.MenuWeixinVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MenuAdapter {
    private static final Logger logger = LoggerFactory.getLogger(MenuAdapter.class);

    public static String assembleMenu(List<MenuWeixinVO> list) {
        logger.info("assemble menu for weixin api. ");
        String menuString = "";
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList menus = new ArrayList();
            for (MenuWeixinVO menuVo : list) {
                HashMap<String, Object> menu = new HashMap<String, Object>();
                if (null != menuVo.getSubMenus() && CollectionUtils.isNotEmpty(menuVo.getSubMenus())) {
                    ArrayList sonMenus = new ArrayList();
                    List<MenuWeixinVO> subVos = menuVo.getSubMenus();
                    for (MenuWeixinVO subVo : subVos) {
                        HashMap<String, String> submenu = new HashMap<String, String>();
                        submenu.put("name", subVo.getName());
                        if ("url".equals(subVo.getType())) {
                            submenu.put("type", "view");
                            submenu.put("url", subVo.getUrl());
                        } else if ("message".equals(subVo.getType())) {
                            submenu.put("type", "click");
                            submenu.put("key", subVo.getKeyword());
                        } else if ("applet".equals(subVo.getType())) {
                            submenu.put("type", "miniprogram");
                            submenu.put("url", "pages/index-v2/index");
                            String appid = "wxbc9bb0cacc22e42b";
                            submenu.put("appid", appid);
                            submenu.put("pagepath", "pages/index-v2/index");
                        }
                        sonMenus.add(submenu);
                    }
                    menu.put("name", menuVo.getName());
                    menu.put("sub_button", sonMenus);
                } else {
                    menu.put("name", menuVo.getName());
                    if ("url".equals(menuVo.getType())) {
                        menu.put("type", "view");
                        menu.put("url", menuVo.getUrl());
                    } else if ("message".equals(menuVo.getType())) {
                        menu.put("type", "click");
                        menu.put("key", menuVo.getKeyword());
                    } else if ("applet".equals(menuVo.getType())) {
                        menu.put("type", "miniprogram");
                        menu.put("url", "pages/index-v2/index");
                        String appid = "wxbc9bb0cacc22e42b";
                        menu.put("appid", appid);
                        menu.put("pagepath", "pages/index-v2/index");
                    }
                }
                menus.add(menu);
            }
            HashMap button = new HashMap();
            button.put("button", menus);
            menuString = JsonKit.toJson(button);
        }
        logger.info("menuString = {}", (Object)menuString);
        return menuString;
    }
}

