/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.trans.vo.order;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.trans.enums.TsOrderBusinessTypeEnum;
import com.thebeastshop.trans.enums.ThirdpartyOrderTypeEnum;
import com.thebeastshop.trans.enums.TsPaymentTypeEnum;
import com.thebeastshop.trans.enums.TsrOrderInvoiceEnum;
import com.thebeastshop.trans.vo.logistics.TsDateUnitVO;
import com.thebeastshop.trans.vo.logistics.TsTimeSlotVO;
import com.thebeastshop.trans.vo.member.TsMemberAddressVO;
import com.thebeastshop.trans.vo.payment.TsPaymentVO;
import com.thebeastshop.trans.vo.price.TsPriceStepVO;

/**
 * 订单详情vo
 * 
 * @author Paul-xiong
 *
 */
public class TsOrderDetailVO extends BaseDO {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 订单基本信息
	 */
	private TsOrderSimpleVO raw = new TsOrderSimpleVO();

	/**
	 * 支付类型
	 */
	private TsPaymentVO payment;

	/**
	 * 多笔支付
	 */
	private List<TsPaymentVO> multiplePayments;

	/**
	 * 订单的包裹信息
	 */
	private Collection<TsOrderParcelVO> packages;

	/**
	 * 价格步骤
	 */
	private Collection<TsPriceStepVO> priceSteps;

	/**
	 * 是否为匿名购买
	 */
	private boolean anonymous;

	/**
	 * 卡片内容
	 */
	private String card;

	/**
	 * 卡片内容
	 */
	private OrderCardVO newCard;

	/**
	 * 可配送日期
	 */
	private TsDateUnitVO deliverableDate;

	/**
	 * 时段
	 */
	private TsTimeSlotVO deliverableTimeSlot;

	/**
	 * 是否使用生日折扣
	 */
	private boolean useBdayDiscount;

	/**
	 * 订单备注
	 */
	private String remark;
	
    /**
     * 拼团信息
     */
	private GrouponVO grouponVO;
	
	/**
	 * 是否可消
	 */
	private boolean isCancelable = false;
	
	/**
	 * 发票状态
	 */
	private TsrOrderInvoiceEnum tsrOrderInvoiceEnum;

	/**
	 * ipos 远程支付分享对象
	 */
	private TsRemotePayShare remotePayShare;

	/**
	 * 订单取件码
	 */
	private TsOrderPickupVO tsOrderPickupVO;

	public TsOrderIdentity getTsOrderIdentity() {
		return raw.getTsOrderIdentity();
	}

	public void setTsOrderIdentity(TsOrderIdentity tsOrderIdentity) {
		raw.setTsOrderIdentity(tsOrderIdentity);
	}
	
	public TsOrderBusinessTypeEnum getOrderType() {
		return raw.getOrderType();
	}

	public void setOrderType(TsOrderBusinessTypeEnum orderType) {
		raw.setOrderType(orderType);
	}

	public TsOrderDetailVO() {
		super();
	}

	public List<TsPaymentTypeEnum> getPayMethods() {
		return raw.getPayMethods();
	}

	public void setPayMethods(List<TsPaymentTypeEnum> payMethods) {
		raw.setPayMethods(payMethods);
	}

	public TsMemberAddressVO getAddress() {
		return raw.getAddress();
	}

	public void setAddress(TsMemberAddressVO address) {
		raw.setAddress(address);
	}

	public boolean isHasOverseaProducts() {
		return raw.isHasOverseaProducts();
	}

	public void setHasOverseaProducts(boolean hasOverseaProducts) {
		raw.setHasOverseaProducts(hasOverseaProducts);
	}

	public TsOrderDetailVO(TsOrderSimpleVO raw) {
		super();
		this.raw = raw;
	}

	public String getId() {
		return raw.getId();
	}

	public void setId(String id) {
		raw.setId(id);
	}

	public TsOrderStateVO getState() {
		return raw.getState();
	}

	public void setState(TsOrderStateVO state) {
		raw.setState(state);
	}

	public long getPayExpireTime() {
		return raw.getPayExpireTime();
	}

	public void setPayExpireTime(long payExpireTime) {
		raw.setPayExpireTime(payExpireTime);
	}

	public Date getCreateTime() {
		return raw.getCreateTime();
	}

	public void setCreateTime(Date createTime) {
		raw.setCreateTime(createTime);
	}

	public BigDecimal getPrice() {
		return raw.getPrice();
	}

	public void setPrice(BigDecimal price) {
		raw.setPrice(price);
	}


	public ShareOrderVO getShareOrder() {
		return raw.getShareOrder();
	}

	public void setShareOrder(ShareOrderVO shareOrder) {
		this.raw.setShareOrder(shareOrder);
	}


	public OrderRedirectVO getRedirect() {
		return raw.getRedirect();
	}

	public void setRedirect(OrderRedirectVO redirect) {
		this.raw.setRedirect(redirect);
	}


	public TsPaymentVO getPayment() {
		return payment;
	}

	public void setPayment(TsPaymentVO payment) {
		this.payment = payment;
	}

	public List<TsPaymentVO> getMultiplePayments() {
		return multiplePayments;
	}

	public void setMultiplePayments(List<TsPaymentVO> multiplePayments) {
		this.multiplePayments = multiplePayments;
	}

	public Collection<TsOrderParcelVO> getPackages() {
		return packages;
	}

	public void setPackages(Collection<TsOrderParcelVO> packages) {
		this.packages = packages;
	}

	public Collection<TsPriceStepVO> getPriceSteps() {
		return priceSteps;
	}

	public void setPriceSteps(Collection<TsPriceStepVO> priceSteps) {
		this.priceSteps = priceSteps;
	}

	public boolean isAnonymous() {
		return anonymous;
	}

	public void setAnonymous(boolean anonymous) {
		this.anonymous = anonymous;
	}

	public String getCard() {
		return card;
	}

	public void setCard(String card) {
		this.card = card;
	}

	public boolean isUseBdayDiscount() {
		return useBdayDiscount;
	}

	public void setUseBdayDiscount(boolean useBdayDiscount) {
		this.useBdayDiscount = useBdayDiscount;
	}

	public TsDateUnitVO getDeliverableDate() {
		return deliverableDate;
	}

	public void setDeliverableDate(TsDateUnitVO deliverableDate) {
		this.deliverableDate = deliverableDate;
	}

	public TsTimeSlotVO getDeliverableTimeSlot() {
		return deliverableTimeSlot;
	}

	public void setDeliverableTimeSlot(TsTimeSlotVO deliverableTimeSlot) {
		this.deliverableTimeSlot = deliverableTimeSlot;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public OrderCardVO getNewCard() {
		return newCard;
	}

	public void setNewCard(OrderCardVO newCard) {
		this.newCard = newCard;
	}

	public LogisticsVO getFurniture() {
		return raw.getFurniture();
	}

	public void setFurniture(LogisticsVO furniture) {
		raw.setFurniture(furniture);
	}

	
	public GrouponVO getGrouponVO() {
		return grouponVO;
	}

	public void setGrouponVO(GrouponVO grouponVO) {
		this.grouponVO = grouponVO;
	}

	public String getTradeNo() {
		return raw.getTradeNo();
	}

	public void setTradeNo(String tradeNo) {
		raw.setTradeNo(tradeNo);
	}
	
	
	public boolean isCancelable() {
		return isCancelable;
	}

	public void setCancelable(boolean isCancelable) {
		this.isCancelable = isCancelable;
	}
	
	public FinalOrderVO getFinalOrderVO() {
		return raw.getFinalOrderVO();
	}

	public void setFinalOrderVO(FinalOrderVO finalOrderVO) {
		raw.setFinalOrderVO(finalOrderVO);
	}
	
	public List<String> getThirdpartyOrderCodes() {
		return raw.getThirdpartyOrderCodes();
	}

	public void setThirdpartyOrderCodes(List<String> thirdpartyOrderCodes) {
		raw.setThirdpartyOrderCodes (thirdpartyOrderCodes);
	}

	public ThirdpartyOrderTypeEnum getThirdpartyOrderTypeEnum() {
		return raw.getThirdpartyOrderTypeEnum();
	}

	public void setThirdpartyOrderTypeEnum(ThirdpartyOrderTypeEnum tsOutOrderTypeEnum) {
		 raw.setThirdpartyOrderTypeEnum(tsOutOrderTypeEnum);
	}

	public TsrOrderInvoiceEnum getTsrOrderInvoiceEnum() {
		return tsrOrderInvoiceEnum;
	}

	public void setTsrOrderInvoiceEnum(TsrOrderInvoiceEnum tsrOrderInvoiceEnum) {
		this.tsrOrderInvoiceEnum = tsrOrderInvoiceEnum;
	}

	public String getSalesChannelType() {
		return raw.getSalesChannelType();
	}

	public void setSalesChannelType(String salesChannelType) {
		raw.setSalesChannelType(salesChannelType);
	}

	public String getChannelCode() {
		return raw.getChannelCode();
	}

	public void setChannelCode(String channelCode) {
		raw.setChannelCode(channelCode);
	}

	public TsRemotePayShare getRemotePayShare() {
		return remotePayShare;
	}

	public void setRemotePayShare(TsRemotePayShare remotePayShare) {
		this.remotePayShare = remotePayShare;
	}

	public TsOrderPickupVO getTsOrderPickupVO() {
		return tsOrderPickupVO;
	}

	public void setTsOrderPickupVO(TsOrderPickupVO tsOrderPickupVO) {
		this.tsOrderPickupVO = tsOrderPickupVO;
	}

	public AccessWayEnum getSoAccessWayEnum() {
		return raw.getSoAccessWayEnum();
	}

	@Override
	public String toString() {
		return "TsOrderDetailVO{" +
				"raw=" + raw +
				", payment=" + payment +
				", multiplePayments=" + multiplePayments +
				", packages=" + packages +
				", priceSteps=" + priceSteps +
				", anonymous=" + anonymous +
				", card='" + card + '\'' +
				", newCard=" + newCard +
				", deliverableDate=" + deliverableDate +
				", deliverableTimeSlot=" + deliverableTimeSlot +
				", useBdayDiscount=" + useBdayDiscount +
				", remark='" + remark + '\'' +
				", grouponVO=" + grouponVO +
				", isCancelable=" + isCancelable +
				", tsrOrderInvoiceEnum=" + tsrOrderInvoiceEnum +
				", remotePayShare=" + remotePayShare +
				", tsOrderPickupVO=" + tsOrderPickupVO +
				'}';
	}
}
