/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.trans.enums;

import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.trans.enums.TsRefundTypeEnum;
import com.thebeastshop.trans.vo.refund.RefundInfoVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum TsRefundStepEnum {
    APPLY("\u63d0\u4ea4\u7533\u8bf7"){

        @Override
        public boolean canCancelRefund() {
            return true;
        }

        @Override
        public String getDesc() {
            return "\u4e70\u5bb6\u53d1\u8d77\u7533\u8bf7";
        }

        @Override
        public RefundInfoVO.RefundStepInfo getContent(RefundStepContentParam refundStepContentParam) {
            RefundInfoVO.RefundStepInfo refundStepInfo = new RefundInfoVO.RefundStepInfo();
            refundStepInfo.setRefundStep(APPLY);
            if (null == refundStepContentParam.failType) {
                refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u4f60\u5df2\u63d0\u4ea4\u7533\u8bf7\uff0c\u8bf7\u7b49\u5f85\u5546\u5bb6\u5904\u7406", "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
                if (StringUtils.isNotBlank((CharSequence)refundStepContentParam.acceptLimitCountDownTimeStr)) {
                    refundStepInfo.setDesc(new RefundInfoVO.RefundContentText(String.format("\u8fd8\u5269%s\uff0c\u8d85\u65f6\u7cfb\u7edf\u81ea\u52a8\u540c\u610f", refundStepContentParam.acceptLimitCountDownTimeStr), "", TsRefundStepEnum.REFUND_CONTENT_GRAY));
                } else {
                    refundStepInfo.setDesc(new RefundInfoVO.RefundContentText(String.format("\u5546\u5bb6\u5c06\u5728%s\u4e2a\u5de5\u4f5c\u65e5\u5185\u5904\u7406", refundStepContentParam.acceptWorkDayNum), "", TsRefundStepEnum.REFUND_CONTENT_GRAY));
                }
            } else {
                refundStepInfo.setFailStep(Boolean.TRUE);
                refundStepInfo.setFailType(refundStepContentParam.failType);
                if (RefundStepFailType.SELL_REJECT == refundStepContentParam.failType) {
                    refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u5546\u5bb6\u5df2\u62d2\u7edd,\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d", "", TsRefundStepEnum.REFUND_CONTENT_YELLOW));
                    refundStepInfo.setRejectContent(new RefundInfoVO.RefundContentText(String.format("\u62d2\u7edd\u539f\u56e0\uff1a%s", refundStepContentParam.rejectReason), "", TsRefundStepEnum.REFUND_CONTENT_YELLOW));
                    if (StringUtils.isNotBlank((CharSequence)refundStepContentParam.sellRejectCloseCountDownTimeStr)) {
                        refundStepInfo.setDesc(new RefundInfoVO.RefundContentText(String.format("\u8fd8\u5269%s\uff0c\u7533\u8bf7\u5c06\u81ea\u52a8\u5173\u95ed", refundStepContentParam.sellRejectCloseCountDownTimeStr), "", TsRefundStepEnum.REFUND_CONTENT_GRAY));
                    }
                } else if (RefundStepFailType.CLOSE == refundStepContentParam.failType) {
                    refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u7533\u8bf7\u5df2\u5173\u95ed", "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
                    refundStepInfo.setRejectContent(new RefundInfoVO.RefundContentText(String.format("\u5173\u95ed\u539f\u56e0\uff1a%s", refundStepContentParam.closeReason), "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
                    refundStepInfo.setDesc(new RefundInfoVO.RefundContentText(DateUtil.formatDate((Date)refundStepContentParam.closeTime, (String)"yyyy-MM-dd HH:mm:ss"), "", TsRefundStepEnum.REFUND_CONTENT_GRAY));
                }
            }
            return refundStepInfo;
        }
    }
    ,
    ALLOW("\u5356\u5bb6\u540c\u610f"){

        @Override
        public boolean canCancelRefund() {
            return true;
        }

        @Override
        public String getDesc() {
            return "\u5546\u5bb6\u540c\u610f\u672c\u6b21\u552e\u540e\u7533\u8bf7";
        }

        @Override
        public RefundInfoVO.RefundStepInfo getContent(RefundStepContentParam refundStepContentParam) {
            RefundInfoVO.RefundStepInfo refundStepInfo = new RefundInfoVO.RefundStepInfo();
            refundStepInfo.setRefundStep(ALLOW);
            if (null == refundStepContentParam.failType) {
                refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u5546\u5bb6\u5df2\u540c\u610f\u552e\u540e\u7533\u8bf7\n\u8bf7\u5728\u65f6\u9650\u5185\u586b\u5199\u5feb\u9012\u5355\u53f7\u5e76\u5bc4\u56de\u5546\u54c1", "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
                if (StringUtils.isNotBlank((CharSequence)refundStepContentParam.deliveryCloseCountDownTimeStr)) {
                    refundStepInfo.setDesc(new RefundInfoVO.RefundContentText(String.format("\u8fd8\u5269%s\uff0c\u8d85\u65f6\u5c06\u81ea\u52a8\u5173\u95ed", refundStepContentParam.deliveryCloseCountDownTimeStr), "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
                }
            } else {
                refundStepInfo.setFailStep(Boolean.TRUE);
                refundStepInfo.setFailType(refundStepContentParam.failType);
                if (RefundStepFailType.SELL_REJECT == refundStepContentParam.failType) {
                    refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u5546\u5bb6\u5df2\u62d2\u7edd,\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d", "", TsRefundStepEnum.REFUND_CONTENT_YELLOW));
                    refundStepInfo.setRejectContent(new RefundInfoVO.RefundContentText(String.format("\u62d2\u7edd\u539f\u56e0\uff1a%s", refundStepContentParam.rejectReason), "", TsRefundStepEnum.REFUND_CONTENT_YELLOW));
                    if (StringUtils.isNotBlank((CharSequence)refundStepContentParam.sellRejectCloseCountDownTimeStr)) {
                        refundStepInfo.setDesc(new RefundInfoVO.RefundContentText(String.format("\u8fd8\u5269%s\uff0c\u7533\u8bf7\u5c06\u81ea\u52a8\u5173\u95ed", refundStepContentParam.sellRejectCloseCountDownTimeStr), "", TsRefundStepEnum.REFUND_CONTENT_GRAY));
                    }
                } else if (RefundStepFailType.CLOSE == refundStepContentParam.failType) {
                    refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u7533\u8bf7\u5df2\u5173\u95ed", "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
                    refundStepInfo.setRejectContent(new RefundInfoVO.RefundContentText(String.format("\u5173\u95ed\u539f\u56e0\uff1a%s", refundStepContentParam.closeReason), "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
                    refundStepInfo.setDesc(new RefundInfoVO.RefundContentText(DateUtil.formatDate((Date)refundStepContentParam.closeTime, (String)"yyyy-MM-dd HH:mm:ss"), "", TsRefundStepEnum.REFUND_CONTENT_GRAY));
                }
            }
            return refundStepInfo;
        }
    }
    ,
    RETURN("\u4e70\u5bb6\u5bc4\u56de"){

        @Override
        public boolean canCancelRefund() {
            return false;
        }

        @Override
        public String getDesc() {
            return "\u4e70\u5bb6\u5bc4\u56de\u5546\u54c1";
        }

        @Override
        public RefundInfoVO.RefundStepInfo getContent(RefundStepContentParam refundStepContentParam) {
            RefundInfoVO.RefundStepInfo refundStepInfo = new RefundInfoVO.RefundStepInfo();
            refundStepInfo.setRefundStep(RETURN);
            if (null == refundStepContentParam.failType) {
                if (TsRefundTypeEnum.EXCHANGE == refundStepContentParam.refundType) {
                    refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u8bf7\u7b49\u5f85\u5546\u5bb6\u6536\u8d27\u5e76\u53d1\u51fa\u65b0\u5546\u54c1", "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
                } else {
                    refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u8bf7\u7b49\u5f85\u5546\u5bb6\u6536\u8d27\u5e76\u9000\u6b3e", "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
                }
            } else {
                refundStepInfo.setFailStep(Boolean.TRUE);
                refundStepInfo.setFailType(refundStepContentParam.failType);
                if (RefundStepFailType.SELL_REJECT == refundStepContentParam.failType) {
                    refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u5546\u5bb6\u5df2\u62d2\u7edd\uff0c\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d", "", TsRefundStepEnum.REFUND_CONTENT_YELLOW));
                    refundStepInfo.setRejectContent(new RefundInfoVO.RefundContentText(String.format("\u62d2\u7edd\u539f\u56e0\uff1a%s", refundStepContentParam.rejectReason), "", TsRefundStepEnum.REFUND_CONTENT_YELLOW));
                    if (StringUtils.isNotBlank((CharSequence)refundStepContentParam.sellRejectCloseCountDownTimeStr)) {
                        refundStepInfo.setDesc(new RefundInfoVO.RefundContentText(String.format("\u8fd8\u5269%s\uff0c\u7533\u8bf7\u5c06\u81ea\u52a8\u5173\u95ed", refundStepContentParam.sellRejectCloseCountDownTimeStr), "", TsRefundStepEnum.REFUND_CONTENT_GRAY));
                    }
                } else if (RefundStepFailType.CLOSE == refundStepContentParam.failType) {
                    refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u7533\u8bf7\u5df2\u5173\u95ed", "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
                    refundStepInfo.setRejectContent(new RefundInfoVO.RefundContentText(String.format("\u5173\u95ed\u539f\u56e0\uff1a%s", refundStepContentParam.closeReason), "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
                    refundStepInfo.setDesc(new RefundInfoVO.RefundContentText(DateUtil.formatDate((Date)refundStepContentParam.closeTime, (String)"yyyy-MM-dd HH:mm:ss"), "", TsRefundStepEnum.REFUND_CONTENT_GRAY));
                }
            }
            return refundStepInfo;
        }
    }
    ,
    REFUND("\u5546\u5bb6\u9000\u6b3e"){

        @Override
        public boolean canCancelRefund() {
            return false;
        }

        @Override
        public String getDesc() {
            return "\u5546\u5bb6\u64cd\u4f5c\u9000\u6b3e";
        }

        @Override
        public RefundInfoVO.RefundStepInfo getContent(RefundStepContentParam refundStepContentParam) {
            RefundInfoVO.RefundStepInfo refundStepInfo = new RefundInfoVO.RefundStepInfo();
            refundStepInfo.setRefundStep(REFUND);
            if (null == refundStepContentParam.failType) {
                refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u5546\u5bb6\u5df2\u64cd\u4f5c\u9000\u6b3e", "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
                refundStepInfo.setDesc(new RefundInfoVO.RefundContentText(String.format("\u9000\u6b3e\u5c06\u5728%s\u4e2a\u5de5\u4f5c\u65e5\u8fd4\u56de", refundStepContentParam.refundWorkDayNum), "", TsRefundStepEnum.REFUND_CONTENT_GRAY));
            }
            return refundStepInfo;
        }
    }
    ,
    REFUND_SUCCESS("\u9000\u6b3e\u6210\u529f"){

        @Override
        public boolean canCancelRefund() {
            return false;
        }

        @Override
        public String getDesc() {
            return "\u9000\u6b3e\u6210\u529f";
        }

        @Override
        public RefundInfoVO.RefundStepInfo getContent(RefundStepContentParam refundStepContentParam) {
            RefundInfoVO.RefundStepInfo refundStepInfo = new RefundInfoVO.RefundStepInfo();
            refundStepInfo.setRefundStep(REFUND_SUCCESS);
            if (null == refundStepContentParam.failType) {
                refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u9000\u6b3e\u6210\u529f", refundStepContentParam.getRefundAmt().setScale(2, RoundingMode.DOWN).toString(), TsRefundStepEnum.REFUND_CONTENT_YELLOW));
                refundStepInfo.setDesc(new RefundInfoVO.RefundContentText("\u9000\u6b3e\u65f6\u95f4", DateUtil.formatDate((Date)refundStepContentParam.refundTime, (String)"yyyy-MM-dd HH:mm:ss"), TsRefundStepEnum.REFUND_CONTENT_BLACK));
                ArrayList<RefundInfoVO.RefundContentText> paymentRefundAmts = new ArrayList<RefundInfoVO.RefundContentText>(refundStepContentParam.paymentRefundAmt.size());
                for (RefundStepContentParam.RefundPaymentAmt refundPaymentAmt : refundStepContentParam.paymentRefundAmt) {
                    paymentRefundAmts.add(new RefundInfoVO.RefundContentText("\u9000\u56de" + refundPaymentAmt.paymentType, "\u00a5" + refundPaymentAmt.paymentRefundAmt.setScale(2, RoundingMode.DOWN), TsRefundStepEnum.REFUND_CONTENT_BLACK));
                }
                refundStepInfo.setPaymentRefundAmts(paymentRefundAmts);
            }
            return refundStepInfo;
        }
    }
    ,
    EXCHANGE_SEND("\u5546\u5bb6\u53d1\u8d27"){

        @Override
        public boolean canCancelRefund() {
            return false;
        }

        @Override
        public String getDesc() {
            return "\u5546\u5bb6\u53d1\u8d27";
        }

        @Override
        public RefundInfoVO.RefundStepInfo getContent(RefundStepContentParam refundStepContentParam) {
            RefundInfoVO.RefundStepInfo refundStepInfo = new RefundInfoVO.RefundStepInfo();
            refundStepInfo.setRefundStep(EXCHANGE_SEND);
            if (null == refundStepContentParam.failType) {
                refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u65b0\u5546\u54c1\u5df2\u53d1\u8d27\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u7269\u6d41\u4fe1\u606f", "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
            }
            return refundStepInfo;
        }
    }
    ,
    EXCHANGE_SUCCESS("\u6362\u8d27\u5b8c\u6210"){

        @Override
        public boolean canCancelRefund() {
            return false;
        }

        @Override
        public String getDesc() {
            return "\u6362\u8d27\u5b8c\u6210";
        }

        @Override
        public RefundInfoVO.RefundStepInfo getContent(RefundStepContentParam refundStepContentParam) {
            RefundInfoVO.RefundStepInfo refundStepInfo = new RefundInfoVO.RefundStepInfo();
            refundStepInfo.setRefundStep(EXCHANGE_SEND);
            if (null == refundStepContentParam.failType) {
                refundStepInfo.setTitle(new RefundInfoVO.RefundContentText("\u6362\u8d27\u5b8c\u6210", "", TsRefundStepEnum.REFUND_CONTENT_BLACK));
                refundStepInfo.setDesc(new RefundInfoVO.RefundContentText("\u6362\u8d27\u670d\u52a1\u5df2\u5b8c\u6210\uff0c\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d", "", TsRefundStepEnum.REFUND_CONTENT_GRAY));
                refundStepInfo.setDateText(new RefundInfoVO.RefundContentText(DateUtil.formatDate((Date)refundStepContentParam.getCloseTime(), (String)"yyyy-MM-dd HH:mm:ss"), "", TsRefundStepEnum.REFUND_CONTENT_GRAY));
            }
            return refundStepInfo;
        }
    };

    static final String REFUND_CONTENT_YELLOW = "#DD4F14";
    static final String REFUND_CONTENT_BLACK = "#000000";
    static final String REFUND_CONTENT_GRAY = "#9A9A9A";
    private final String name;

    private TsRefundStepEnum(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean canCancelRefund();

    public abstract RefundInfoVO.RefundStepInfo getContent(RefundStepContentParam var1);

    public abstract String getDesc();

    public static TsRefundStepEnum getByRefundStatus(Integer refundStatus) {
        if (ReturnRequestState.STATUS_CREATE.equals(refundStatus) || ReturnRequestState.STATUS_WAITING_CHECK.equals(refundStatus)) {
            return APPLY;
        }
        if (ReturnRequestState.STATUS_BUYER_DELIVER.equals(refundStatus)) {
            return ALLOW;
        }
        if (ReturnRequestState.STATUS_WAITING_RECEIVE.equals(refundStatus) || ReturnRequestState.STATUS_WAITING_CHECK_AFTER_RECEIVE.equals(refundStatus) || ReturnRequestState.STATUS_SELLEL_DELIVERY.equals(refundStatus)) {
            return RETURN;
        }
        if (ReturnRequestState.STATUS_WAITING_REFUND.equals(refundStatus)) {
            return REFUND;
        }
        if (ReturnRequestState.STATUS_FINISHED.equals(refundStatus)) {
            return REFUND_SUCCESS;
        }
        return null;
    }

    public static enum RefundSimpleStatusType {
        APPLY("\u7533\u8bf7\u4e2d"),
        SUCCESS("\u552e\u540e\u5b8c\u6210"),
        CLOSE("\u552e\u540e\u5173\u95ed");

        public String desc;

        private RefundSimpleStatusType(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum RefundStepFailType {
        CLOSE,
        SELL_REJECT;

    }

    public static class RefundStepContentParam {
        private TsRefundTypeEnum refundType;
        private RefundStepFailType failType;
        private String acceptLimitCountDownTimeStr;
        private String acceptWorkDayNum;
        private String sellRejectCloseCountDownTimeStr;
        private String deliveryCloseCountDownTimeStr;
        private String refundWorkDayNum;
        private BigDecimal refundAmt;
        private BigDecimal refundDate;
        private List<RefundPaymentAmt> paymentRefundAmt;
        private Date refundTime;
        private Date refundFailTime;
        private Date closeTime;
        private String rejectReason;
        private String closeReason;

        public String getAcceptWordDayNum() {
            return this.acceptWorkDayNum;
        }

        public void setAcceptWorkDayNum(String acceptWorkDayNum) {
            this.acceptWorkDayNum = acceptWorkDayNum;
        }

        public TsRefundTypeEnum getRefundType() {
            return this.refundType;
        }

        public void setRefundType(TsRefundTypeEnum refundType) {
            this.refundType = refundType;
        }

        public RefundStepFailType getFailType() {
            return this.failType;
        }

        public void setFailType(RefundStepFailType failType) {
            this.failType = failType;
        }

        public BigDecimal getRefundAmt() {
            return this.refundAmt;
        }

        public void setRefundAmt(BigDecimal refundAmt) {
            this.refundAmt = refundAmt;
        }

        public BigDecimal getRefundDate() {
            return this.refundDate;
        }

        public void setRefundDate(BigDecimal refundDate) {
            this.refundDate = refundDate;
        }

        public List<RefundPaymentAmt> getPaymentRefundAmt() {
            return this.paymentRefundAmt;
        }

        public void setPaymentRefundAmt(List<RefundPaymentAmt> paymentRefundAmt) {
            this.paymentRefundAmt = paymentRefundAmt;
        }

        public String getRejectReason() {
            return this.rejectReason;
        }

        public void setRejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
        }

        public String getCloseReason() {
            return this.closeReason;
        }

        public void setCloseReason(String closeReason) {
            this.closeReason = closeReason;
        }

        public String getAcceptLimitCountDownTimeStr() {
            return this.acceptLimitCountDownTimeStr;
        }

        public void setAcceptLimitCountDownTimeStr(String acceptLimitCountDownTimeStr) {
            this.acceptLimitCountDownTimeStr = acceptLimitCountDownTimeStr;
        }

        public String getSellRejectCloseCountDownTimeStr() {
            return this.sellRejectCloseCountDownTimeStr;
        }

        public void setSellRejectCloseCountDownTimeStr(String sellRejectCloseCountDownTimeStr) {
            this.sellRejectCloseCountDownTimeStr = sellRejectCloseCountDownTimeStr;
        }

        public String getDeliveryCloseCountDownTimeStr() {
            return this.deliveryCloseCountDownTimeStr;
        }

        public void setDeliveryCloseCountDownTimeStr(String deliveryCloseCountDownTimeStr) {
            this.deliveryCloseCountDownTimeStr = deliveryCloseCountDownTimeStr;
        }

        public String getRefundWorkDayNum() {
            return this.refundWorkDayNum;
        }

        public void setRefundWorkDayNum(String refundWorkDayNum) {
            this.refundWorkDayNum = refundWorkDayNum;
        }

        public Date getRefundTime() {
            return this.refundTime;
        }

        public void setRefundTime(Date refundTime) {
            this.refundTime = refundTime;
        }

        public Date getRefundFailTime() {
            return this.refundFailTime;
        }

        public void setRefundFailTime(Date refundFailTime) {
            this.refundFailTime = refundFailTime;
        }

        public Date getCloseTime() {
            return this.closeTime;
        }

        public void setCloseTime(Date closeTime) {
            this.closeTime = closeTime;
        }

        public static class RefundPaymentAmt {
            private String paymentType;
            private BigDecimal paymentRefundAmt;

            public RefundPaymentAmt() {
            }

            public RefundPaymentAmt(String paymentType, BigDecimal paymentRefundAmt) {
                this.paymentType = paymentType;
                this.paymentRefundAmt = paymentRefundAmt;
            }

            public String getPaymentType() {
                return this.paymentType;
            }

            public void setPaymentType(String paymentType) {
                this.paymentType = paymentType;
            }

            public BigDecimal getPaymentRefundAmt() {
                return this.paymentRefundAmt;
            }

            public void setPaymentRefundAmt(BigDecimal paymentRefundAmt) {
                this.paymentRefundAmt = paymentRefundAmt;
            }
        }
    }

    public static class ReturnRequestState {
        public static final Integer STATUS_CREATE = 1;
        public static final Integer STATUS_WAITING_CHECK = 2;
        public static final Integer STATUS_WAITING_RECEIVE = 3;
        public static final Integer STATUS_WAITING_CHECK_AFTER_RECEIVE = 4;
        public static final Integer STATUS_WAITING_REFUND = 5;
        public static final Integer STATUS_BUYER_DELIVER = 7;
        public static final Integer STATUS_SELLEL_DELIVERY = 8;
        public static final Integer STATUS_FINISHED = 9;
    }
}

