package com.thebeastshop.trans.vo.refund;

import com.thebeastshop.trans.dto.refund.RefundCreateDTO;
import com.thebeastshop.trans.enums.TsRefundStepEnum;
import com.thebeastshop.trans.enums.TsRefundTypeEnum;
import com.thebeastshop.trans.vo.member.TsMemberAddressVO;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 售后详情
 */
public class RefundInfoVO implements Serializable {

    private static final long serialVersionUID = 8024107512770135449L;

    /**
     * 售后单id
     */
    private Long refundOrderId;

    /**
     * 售后类型
     */
    private TsRefundTypeEnum type;

    /**
     * 是否支持再次申请售后
     */
    private Boolean canReApply;

    /**
     * 是否能撤销售后
     */
    private Boolean canCancel;

    /**
     * 退款总金额
     */
    private BigDecimal refundTotalAmt;

    /**
     * 售后商品
     */
    private List<RefundProduct> refundProducts;

    /**
     * 售后文案
     * 前端字体大小需要写死，所以只能写死固定字段名称，前端根据状态去取文案
     */
    private RefundStepInfo refundStepInfo;

    /**
     * 售后物流信息
     */
    private ReturnDeliveryInfo returnDeliveryInfo;

    /**
     * 协商历史
     */
    private List<RefundTrackVO> refundTrackVOS;

    /**
     * 地址信息
     */
    private TsMemberAddressVO address;

    public TsRefundTypeEnum getType() {
        return type;
    }

    public void setType(TsRefundTypeEnum type) {
        this.type = type;
    }

    public Long getRefundOrderId() {
        return refundOrderId;
    }

    public void setRefundOrderId(Long refundOrderId) {
        this.refundOrderId = refundOrderId;
    }

    public RefundStepInfo getRefundStepInfo() {
        return refundStepInfo;
    }

    public void setRefundStepInfo(RefundStepInfo refundStepInfo) {
        this.refundStepInfo = refundStepInfo;
    }

    public Boolean getCanReApply() {
        return canReApply;
    }

    public List<RefundTrackVO> getRefundTrackVOS() {
        return refundTrackVOS;
    }

    public void setRefundTrackVOS(List<RefundTrackVO> refundTrackVOS) {
        this.refundTrackVOS = refundTrackVOS;
    }

    public TsMemberAddressVO getAddress() {
        return address;
    }

    public void setAddress(TsMemberAddressVO address) {
        this.address = address;
    }

    public void setCanReApply(Boolean canReApply) {
        this.canReApply = canReApply;
    }

    public Boolean getCanCancel() {
        return canCancel;
    }

    public void setCanCancel(Boolean canCancel) {
        this.canCancel = canCancel;
    }

    public BigDecimal getRefundTotalAmt() {
        return refundTotalAmt;
    }

    public void setRefundTotalAmt(BigDecimal refundTotalAmt) {
        this.refundTotalAmt = refundTotalAmt;
    }


    public List<RefundProduct> getRefundProducts() {
        return refundProducts;
    }

    public void setRefundProducts(List<RefundProduct> refundProducts) {
        this.refundProducts = refundProducts;
    }


    public ReturnDeliveryInfo getReturnDeliveryInfo() {
        return returnDeliveryInfo;
    }

    public void setReturnDeliveryInfo(ReturnDeliveryInfo returnDeliveryInfo) {
        this.returnDeliveryInfo = returnDeliveryInfo;
    }

    public static class ReturnDeliveryInfo implements Serializable {

        private static final long serialVersionUID = -7274928994803896339L;

        /**
         * 退货仓
         */
        private ReturnWareHouse returnWareHouse;

        public ReturnWareHouse getReturnWareHouse() {
            return returnWareHouse;
        }

        public void setReturnWareHouse(ReturnWareHouse returnWareHouse) {
            this.returnWareHouse = returnWareHouse;
        }
    }


    /**
     * 退货仓库
     */
    public static class ReturnWareHouse implements Serializable {
        private static final long serialVersionUID = -5643987697233205635L;
        /**
         * 收货人姓名
         */
        private String receiveName;
        /**
         * 收货人地址
         */
        private String receiveAddress;
        /**
         * 收货人手机
         */
        private String receivePhone;

        public String getReceiveName() {
            return receiveName;
        }

        public void setReceiveName(String receiveName) {
            this.receiveName = receiveName;
        }

        public String getReceiveAddress() {
            return receiveAddress;
        }

        public void setReceiveAddress(String receiveAddress) {
            this.receiveAddress = receiveAddress;
        }

        public String getReceivePhone() {
            return receivePhone;
        }

        public void setReceivePhone(String receivePhone) {
            this.receivePhone = receivePhone;
        }
    }


    /**
     * 售后文案文本
     */
    public static class RefundContentText implements Serializable {
        private static final long serialVersionUID = 2312528537372800788L;
        /**
         * 售后文案，一行一条内容
         */
        private String text;

        /**
         * 扩展文案，拆开的文案，例如退款金额的文案钱数量就放在这里
         */
        private String exter;

        /**
         * 字体颜色
         */
        private String fontColor;

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getFontColor() {
            return fontColor;
        }

        public void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        public String getExter() {
            return exter;
        }

        public void setExter(String exter) {
            this.exter = exter;
        }

        public RefundContentText(String text, String exter, String fontColor) {
            this.text = text;
            this.exter = exter;
            this.fontColor = fontColor;
        }
    }

    /**
     * 售后文案
     */
    public static class RefundStepInfo implements Serializable {

        private static final long serialVersionUID = 2312528537372800788L;
        /**
         * 当前步骤失败类型
         */
        private TsRefundStepEnum.RefundStepFailType failType;

        /**
         * 当前是否是失败的步骤
         */
        private Boolean failStep = Boolean.FALSE;

        /**
         * 售后步骤
         */
        private TsRefundStepEnum refundStep;

        /**
         * 标题
         */
        private RefundContentText title;

        /**
         * 拒绝理由和描述
         */
        private RefundContentText rejectContent;

        /**
         * 描述
         */
        private RefundContentText desc;

        /**
         * 时间
         */
        private RefundContentText dateText;

        /**
         * 支付渠道的退款金额
         */
        private List<RefundContentText> paymentRefundAmts;

        public RefundContentText getTitle() {
            return title;
        }

        public void setTitle(RefundContentText title) {
            this.title = title;
        }

        public RefundContentText getRejectContent() {
            return rejectContent;
        }

        public void setRejectContent(RefundContentText rejectContent) {
            this.rejectContent = rejectContent;
        }

        public RefundContentText getDesc() {
            return desc;
        }

        public void setDesc(RefundContentText desc) {
            this.desc = desc;
        }

        public RefundContentText getDateText() {
            return dateText;
        }

        public void setDateText(RefundContentText dateText) {
            this.dateText = dateText;
        }

        public List<RefundContentText> getPaymentRefundAmts() {
            return paymentRefundAmts;
        }

        public void setPaymentRefundAmts(List<RefundContentText> paymentRefundAmts) {
            this.paymentRefundAmts = paymentRefundAmts;
        }

        public TsRefundStepEnum.RefundStepFailType getFailType() {
            return failType;
        }

        public void setFailType(TsRefundStepEnum.RefundStepFailType failType) {
            this.failType = failType;
        }

        public Boolean getFailStep() {
            return failStep;
        }

        public void setFailStep(Boolean failStep) {
            this.failStep = failStep;
        }

        public TsRefundStepEnum getRefundStep() {
            return refundStep;
        }

        public void setRefundStep(TsRefundStepEnum refundStep) {
            this.refundStep = refundStep;
        }
    }

    /**
     * 售后商品行信息
     */
    public static class RefundProduct implements Serializable {

        private static final long serialVersionUID = 1458331328001524015L;

        /**
         * 售后商品行spv信息
         */
        private RefundSpv refundSpv;

        /**
         * 换货商品SPV信息
         */
        private ExchangeSpv exchangeSpv;

        /**
         * 售后类型
         */
        private TsRefundTypeEnum refundType;

        /**
         * 售后理由
         */
        private String refundReason;

        /**
         * 售后描述
         */
        private String refundDesc;

        /**
         * 退货商品数量
         */
        private Integer returnNum;

        /**
         * 退款金额
         */
        private BigDecimal refundAmt;

        /**
         * 申请时间
         */
        private String applyTime;

        /**
         * 售后媒体文件
         */
        private List<RefundCreateDTO.RefundMedia> refundMedias;

        public String getRefundDesc() {
            return refundDesc;
        }

        public void setRefundDesc(String refundDesc) {
            this.refundDesc = refundDesc;
        }

        public RefundSpv getRefundSpv() {
            return refundSpv;
        }

        public void setRefundSpv(RefundSpv refundSpv) {
            this.refundSpv = refundSpv;
        }

        public ExchangeSpv getExchangeSpv() {
            return exchangeSpv;
        }

        public void setExchangeSpv(ExchangeSpv exchangeSpv) {
            this.exchangeSpv = exchangeSpv;
        }

        public TsRefundTypeEnum getRefundType() {
            return refundType;
        }

        public void setRefundType(TsRefundTypeEnum refundType) {
            this.refundType = refundType;
        }

        public String getRefundReason() {
            return refundReason;
        }

        public void setRefundReason(String refundReason) {
            this.refundReason = refundReason;
        }

        public Integer getReturnNum() {
            return returnNum;
        }

        public void setReturnNum(Integer returnNum) {
            this.returnNum = returnNum;
        }

        public BigDecimal getRefundAmt() {
            return refundAmt;
        }

        public void setRefundAmt(BigDecimal refundAmt) {
            this.refundAmt = refundAmt;
        }

        public String getApplyTime() {
            return applyTime;
        }

        public void setApplyTime(String applyTime) {
            this.applyTime = applyTime;
        }

        public List<RefundCreateDTO.RefundMedia> getRefundMedias() {
            return refundMedias;
        }

        public void setRefundMedias(List<RefundCreateDTO.RefundMedia> refundMedias) {
            this.refundMedias = refundMedias;
        }
    }


    /**
     * 售后商品行信息
     */
    public static class RefundSpv implements Serializable {

        private static final long serialVersionUID = 1458331328001524015L;

        /**
         * 商品行 id
         */
        private Long packageSkuId;

        /**
         * 是否赠品
         */
        private Boolean isGift;

        /**
         * 购买数量
         */
        private Integer quantity;

        /**
         * 图片
         */
        private String image;

        /**
         * 品牌名
         */
        private String brandName;

        /**
         * 商品名
         */
        private String name;

        /**
         * 商品 code
         */
        private String productCode;

        /**
         * 规格描述
         */
        private String spvDesc;

        /**
         * 原价
         */
        private BigDecimal rawPrice;

        /**
         * 现价
         */
        private BigDecimal price;

        public Long getPackageSkuId() {
            return packageSkuId;
        }

        public void setPackageSkuId(Long packageSkuId) {
            this.packageSkuId = packageSkuId;
        }

        public Boolean getGift() {
            return isGift;
        }

        public void setGift(Boolean gift) {
            isGift = gift;
        }

        public Integer getQuantity() {
            return quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public String getImage() {
            return image;
        }

        public void setImage(String image) {
            this.image = image;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getProductCode() {
            return productCode;
        }

        public String getBrandName() {
            return brandName;
        }

        public void setBrandName(String brandName) {
            this.brandName = brandName;
        }

        public void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        public String getSpvDesc() {
            return spvDesc;
        }

        public void setSpvDesc(String spvDesc) {
            this.spvDesc = spvDesc;
        }

        public BigDecimal getRawPrice() {
            return rawPrice;
        }

        public void setRawPrice(BigDecimal rawPrice) {
            this.rawPrice = rawPrice;
        }

        public BigDecimal getPrice() {
            return price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }
    }

    /**
     * 换货商品信息
     */
    public static class ExchangeSpv implements Serializable {

        private static final long serialVersionUID = 1458331328001524015L;

        /**
         * 商品名
         */
        private String name;

        /**
         * 规格描述
         */
        private String spvDesc;

        /**
         * 购买数量
         */
        private Integer quantity;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSpvDesc() {
            return spvDesc;
        }

        public void setSpvDesc(String spvDesc) {
            this.spvDesc = spvDesc;
        }

        public Integer getQuantity() {
            return quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }
    }

}
