package com.thebeastshop.trans.dto;

import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.trans.enums.TsTransStatusEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName: TsDcOrderListQueryDTO
 * @Description: 订单列表查询参数
 * @Author xiang.gao
 * @Date 2023/11/22 15:49
 */
public class TsDcOrderListQueryDTO implements Serializable {

    /**
     * 会员ID
     */
    private Long memberId;

    /**
     * 渠道编码
     */
    private String channelCode;

    /**
     * 订单创建开始时间
     */
    private Date createTimeBegin;

    /**
     * 订单状态
     */
    private TsTransStatusEnum orderStatus;

    /**
     * 访问渠道
     */
    private AccessWayEnum accessWay;

    /**
     * 起始位置
     */
    private int offset;

    /**
     * 查询数量
     */
    private int limit;

    /**
     * 是否查询第三方订单
     */
    private boolean matchThirdOrder;

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public Date getCreateTimeBegin() {
        return createTimeBegin;
    }

    public void setCreateTimeBegin(Date createTimeBegin) {
        this.createTimeBegin = createTimeBegin;
    }

    public TsTransStatusEnum getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(TsTransStatusEnum orderStatus) {
        this.orderStatus = orderStatus;
    }

    public AccessWayEnum getAccessWay() {
        return accessWay;
    }

    public void setAccessWay(AccessWayEnum accessWay) {
        this.accessWay = accessWay;
    }

    public int getOffset() {
        return offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLimit() {
        return limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean isMatchThirdOrder() {
        return matchThirdOrder;
    }

    public void setMatchThirdOrder(boolean matchThirdOrder) {
        this.matchThirdOrder = matchThirdOrder;
    }

    @Override
    public String toString() {
        return "TsDcOrderListQueryDTO{" +
                "memberId=" + memberId +
                ", channelCode='" + channelCode + '\'' +
                ", createTimeBegin=" + createTimeBegin +
                ", orderStatus=" + orderStatus +
                ", accessWay=" + accessWay +
                ", offset=" + offset +
                ", limit=" + limit +
                '}';
    }
}
