package com.thebeastshop.trans.vo.product;

import com.thebeastshop.common.BaseDO;

import java.sql.Timestamp;

/**
 * 闪购
 *
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-03-03 17:56
 */
public class TsFlashSaleVO extends BaseDO {

    /**
     * 如果不是闪购，或者闪购有效期之外，则为 null
     */
    private Timestamp expiresAt;// 单位秒，距离闪购结束的时间

    private boolean soldOut;// 闪购限额已经售光。如果在闪购有效期内，且闪购限额已经售光，则商品不能购买，显示为
    // soldout。

    public boolean isSoldOut() {
        return soldOut;
    }

    public Timestamp getExpiresAt() {
        return expiresAt;
    }

    public void setExpiresAt(Timestamp expiresAt) {
        this.expiresAt = expiresAt;
    }

    public void setSoldOut(boolean soldOut) {
        this.soldOut = soldOut;
    }

    @Override
    public String toString() {
        return "FlashSaleVO [expiresAt =" + expiresAt + ", soldOut =" + soldOut + "]";
    }

}
