package com.thebeastshop.trans.service;

import java.util.List;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.trans.vo.delivery.TsDeliveryVO;
import com.thebeastshop.trans.vo.member.TsMemberAddressVO;

public interface TsDeliveryService {

	/**
	 * 浦发活动专用，根据地址商品信息取得可配送的日期
	 *
	 * @param prodCodes 商品信息
	 * @param addressId 地址Id
	 * @return TsDeliveryVO
	 */
	TsDeliveryVO pufaAddressDeliveryDate(List<String> prodCodes, Long addressId);

	/**
	 * 获取订单配送信息
	 * @param orderCode
	 */
	ServiceResp<TsMemberAddressVO> getOrderDeliveryInfo(String orderCode);

	/**
	 * 修改包裹配送信息
	 *
	 * @param memberId
	 * @param orderCode
	 * @param addressId
	 * @return
	 */
	ServiceResp modifyPackageDeliverInfo(Long memberId, String orderCode, Long addressId);

}