package com.thebeastshop.trans.enums;

/**
 * 支付方式
 */
public enum TsPaymentTypeEnum {

	CUSTOMER_SERVICE(0, "客服"),
    CASH(1, "现金"),
    DEBIT_CARD(2, "借记卡"),
    CREDIT_CARD(3, "信用卡"),
    WEIXIN(4, "微信"),
    ALIPAY(5, "支付宝"),
    CMB(6, "招行"),
    TRANSFER(7, "转账"),
    YCK(8, "预存款"),
	YEZHU(9, "业主"),
	GIFT_CARD(10, "礼品卡"),
	EXCHANGE(11,"积分"),
	CMB_CSSH(12, "招行掌上生活"),
	MARKET_COUPON(13, "商场券"),
	QUICK_PASS(14, "银联云闪付"),
	FUND(15, "基金"),
	ELEME(16, "饿了么"),
	TM_SHOPPING_FUND(17, "天猫购物金"),
	TM_INTERESTS_FUND(18, "天猫权益金"),
	SHOPPING_MALL_APP(19, "商场小程序"),
	MARKETING_DISCOUNT(20, "商家支付营销优惠")
	;

	
	private Integer code;
	
	private String name;

	TsPaymentTypeEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}
	
	public String getName(){
		return name;
	}

	public static TsPaymentTypeEnum getEnumByCode(Integer code) {
		for (TsPaymentTypeEnum e : TsPaymentTypeEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}
	
	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
