package com.thebeastshop.trans.enums;

public enum TsErrorCodeEnum {
	//1031 表示某个产品行上的产品单价变了
	//1030 是整个订单的总价变了              比方说 折扣啊 优惠券啊 导致整个订单总价不对了
	//1024 产品下架
	//1023 库存不足
	//-10 积分不足
	//OK 通用业务正常返回
    OPERATION_OK(0,"OK"),
    USER_LOGIN_EXIST(-1,"注册失败，用户名已存在"),
    USER_LOGIN_NOT_EXIST(-2,"登陆失败，用户名不存在"),
    //用户名密码验证失败、oe报（验证失败）
    USER_LOGIN_FAILED(-3,"登陆失败，用户名或密码错误"),
    //-4 无效的数据请求地址
    PARAMS_ILLEGAL(-4,"数据请求参数错误"),
    DATA_NOT_EXIST(-5,"数据不存在错误"),
    STSTEM_ERROR(-9,"系统错误"),
    
    PRODUCT_CHECK_ERROR(20010,"商品检查出错"),
    DELIVERY_INFO_ERROR(20011,"获取物流信息出错"),
    
    //内部exception
    DEFAULT_EXCEPTION(-40,"系统内部错误"),
    DATA_NOT_FOUND(404,"数据不存在"),
    ORDER_TIMEOUT(301,"订单超时未支付"),
    ITEM_PRICE_CHANGE(1031,"商品价格发生变化"),
    ORDER_AMOUNT_CHANGE(1030,"订单价格发生变化"),
    ITEM_OFFSHELF(1024,"商品下架"),
    ITEM_OUTOF_QUANTITY(1023,"商品库存不足"),
    LACKOF_POINT(-10,"积分不足"),
    //auth认证失败-签名非法  9999
    AUTHFAILED_SIGN_ILLEGAL(9999,"认证失败-签名非法"),
    //认证失败-参数缺失
    AUTHFAILED_MISS_PARAMS(9998,"认证失败-参数缺失"),
    //认证失败-签名过期
    AUTHFAILED_TIMESTAMP_EXPIRED(9996,"认证失败-签名过期"),
    USER_PAYPWD_ERR(10000,"支付密码有误"),
    NSUFFICIENT_FUND(10001,"未开通存款账号");
	
	public Integer code;
	public String name;

	TsErrorCodeEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}
	
	public String getName(){
		return name;
	}

	public static TsErrorCodeEnum getEnumByCode(Integer code) {
		for (TsErrorCodeEnum e : TsErrorCodeEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}
	
	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
