package com.thebeastshop.trans.vo;


import com.thebeastshop.common.BaseDO;
import com.thebeastshop.trans.enums.TsLabelModeEnum;

/**
 * @author Liang Wenjian
 */
public class TsLabelVO extends BaseDO {

	private TsLabelModeEnum mode = TsLabelModeEnum.TEXT;
	private String type;
	private String typeColor;
	private String typeBgColor = "#537371";
	private String summary;
	private String summaryColor = "#000000";
	private String link;
	private Integer count = 0;
	private boolean valid = true;

	public TsLabelVO(String type, String typeBgColor) {
		super();
		this.type = type;
		this.typeBgColor = typeBgColor;
	}

	public TsLabelVO(String type, String typeBgColor, String summary) {
		super();
		this.type = type;
		this.typeBgColor = typeBgColor;
		this.summary = summary;
	}

	public TsLabelVO(String type, String typeColor, String typeBgColor, String summary) {
		super();
		this.type = type;
		this.typeColor = typeColor;
		this.typeBgColor = typeBgColor;
		this.summary = summary;
	}

	public TsLabelModeEnum getMode() {
		return mode;
	}

	public void setMode(TsLabelModeEnum mode) {
		this.mode = mode;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(final String summary) {
		this.summary = summary;
	}

	public boolean isValid() {
		return valid;
	}

	public void setValid(final boolean valid) {
		this.valid = valid;
	}

	public String getLink() {
		return link;
	}

	public void setLink(final String link) {
		this.link = link;
	}

	public Integer getCount() {
		return count;
	}

	public void setCount(final Integer count) {
		this.count = count;
	}

	public String getSummaryColor() {
		return summaryColor;
	}

	public void setSummaryColor(final String summaryColor) {
		this.summaryColor = summaryColor;
	}

	public String getTypeColor() {
		return typeColor;
	}

	public void setTypeColor(String typeColor) {
		this.typeColor = typeColor;
	}

	public String getTypeBgColor() {
		return typeBgColor;
	}

	public void setTypeBgColor(String typeBgColor) {
		this.typeBgColor = typeBgColor;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + hashCode() + ":{" + "type:'" + type + '\'' + ", summary:'" + summary + '\''
				+ ", valid:" + valid + ", link:'" + link + '\'' + ", count:" + count + ", summaryColor:'" + summaryColor
				+ '\'' + '}';
	}

}
