package com.thebeastshop.trans.enums;

/**
 * 身份证审核状态
 */
public enum TsOrderIdentityEnum {

	INITIAL(0, "初始"), 
	UNDER_REVIEW(1, "审核中"), 
	VERIFIED(2, "审核通过"),
	AUDIT_FAILURE(3, "审核失败");
	
	private Integer code;
	
	private String name;

	TsOrderIdentityEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}
	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public static TsOrderIdentityEnum getByCode(Integer code) {
		for (TsOrderIdentityEnum identityEnum : TsOrderIdentityEnum.values()) {
			if (identityEnum.code.equals(code)) {
				return identityEnum;
			}
		}
		return TsOrderIdentityEnum.INITIAL;
	}
	
	
}
