package com.thebeastshop.trans.enums;

/**
 * 订单支付状态
 */
public enum TsOrderPayStatus {

	NOTSTARTED(0,"未开始"),
	STARTED(1,"已开始"),
	FINISHED(3,"已结束");
	
    private int code;
	
	private String name;
	
	TsOrderPayStatus(int code,String name){
		this.code = code;
		this.name = name;
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}
	
	public static TsOrderPayStatus getEnumByCode(int code) {
		for (TsOrderPayStatus e : TsOrderPayStatus.values()) {
			if (e.getCode()==code) {
				return e;
			}
		}
		return null;
	}


	public void setName(String name) {
		this.name = name;
	}
	
}
