package com.thebeastshop.trans.vo.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import com.thebeastshop.common.enums.AccessWayEnum;
import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.common.collect.Lists;
import com.thebeastshop.common.BaseDO;
import com.thebeastshop.trans.enums.TsOrderBusinessTypeEnum;
import com.thebeastshop.trans.enums.ThirdpartyOrderTypeEnum;
import com.thebeastshop.trans.enums.TsPaymentTypeEnum;
import com.thebeastshop.trans.vo.member.TsMemberAddressVO;

/**
 * 订单基础信息
 * 
 * @author Paul-xiong
 *
 */
public class TsOrderSimpleVO extends BaseDO {
	/**
	 * 订单编号
	 */
	private String id;

	/**
	 * 渠道CODE
	 */
	private String channelCode;

	/**
	 * 渠道类型[线上 online、线下 offline]
	 */
	private String salesChannelType;
	
	/**
	 * 外部订单号
	 */
	private String outOrderCode;
	
	/**
	 * 外部订单类型
	 */
	private ThirdpartyOrderTypeEnum thirdpartyOrderTypeEnum;

	/**
	 * 订单状态
	 */
	private TsOrderStateVO state;

	/**
	 * 支付有效时间（计算得到秒数）
	 */
	private long payExpireTime = 0;

	/**
	 * 创建时间
	 */
	private Date createTime;
	
	/**
	 * 支付时间
	 */
	private Date payTime;
	
	/**
	 * 支付流水号
	 */
	private String tradeNo;
	/**
	 * 价格
	 */
	private BigDecimal price;
	/**
	 * 商品包
	 */
	private Collection<TsOrderProductPackVO> packs = Lists.newArrayList();
	/**
	 * 地址信息
	 */
	private TsMemberAddressVO address;
	/**
	 * 是否包含海外购商品
	 */
	private boolean hasOverseaProducts = false;

	/**
	 * 可用的支付方式
	 */
	private List<TsPaymentTypeEnum> payMethods;

	/**
	 * 订单类型：0普通，1月送鲜花
	 */
	private TsOrderBusinessTypeEnum orderType= TsOrderBusinessTypeEnum.NORMAL;

	/**
	 * 物流
	 */
	private LogisticsVO furniture;

    /**
     * 拼团信息
     */
	private GrouponVO grouponVO;

	/**
	 * 晒单信息
	 */
	private ShareOrderVO shareOrder;

	/**
	 * 跳转对象
	 */
	private OrderRedirectVO redirect;
	
	/**
	 * 身份证信息
	 */
	private TsOrderIdentity tsOrderIdentity;
	
	/**
	 * 尾款对像
	 */
	private FinalOrderVO finalOrderVO; 
	
	
    /**
     * 第三方订单
     */
    private List<String> thirdpartyOrderCodes = new ArrayList<>();

	/**
	 * 订单渠道
	 */
	private  AccessWayEnum soAccessWayEnum;

	public String getSalesChannelType() {
		return salesChannelType;
	}

	public void setSalesChannelType(String salesChannelType) {
		this.salesChannelType = salesChannelType;
	}

	public TsOrderBusinessTypeEnum getOrderType() {
		return orderType;
	}

	public void setOrderType(TsOrderBusinessTypeEnum orderType) {
		this.orderType = orderType;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getChannelCode() {
		return channelCode;
	}

	public void setChannelCode(String channelCode) {
		this.channelCode = channelCode;
	}

	public TsOrderStateVO getState() {
		return state;
	}

	public void setState(TsOrderStateVO state) {
		this.state = state;
	}

	public long getPayExpireTime() {
		return payExpireTime;
	}

	public void setPayExpireTime(long payExpireTime) {
		this.payExpireTime = payExpireTime;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public Collection<TsOrderProductPackVO> getPacks() {
		return packs;
	}

	public void setPacks(Collection<TsOrderProductPackVO> packs) {
		this.packs = packs;
	}

	public TsMemberAddressVO getAddress() {
		return address;
	}

	public void setAddress(TsMemberAddressVO address) {
		this.address = address;
	}

	public boolean isHasOverseaProducts() {
		return hasOverseaProducts;
	}

	public void setHasOverseaProducts(boolean hasOverseaProducts) {
		this.hasOverseaProducts = hasOverseaProducts;
	}

	public List<TsPaymentTypeEnum> getPayMethods() {
		return payMethods;
	}

	public void setPayMethods(List<TsPaymentTypeEnum> payMethods) {
		this.payMethods = payMethods;
	}

	public LogisticsVO getFurniture() {
		return furniture;
	}

	public void setFurniture(LogisticsVO furniture) {
		this.furniture = furniture;
	}

	public GrouponVO getGrouponVO() {
		return grouponVO;
	}

	public void setGrouponVO(GrouponVO grouponVO) {
		this.grouponVO = grouponVO;
	}

	public ShareOrderVO getShareOrder() {
		return shareOrder;
	}

	public void setShareOrder(ShareOrderVO shareOrder) {
		this.shareOrder = shareOrder;
	}

	public Date getPayTime() {
		return payTime;
	}

	public void setPayTime(Date payTime) {
		this.payTime = payTime;
	}

	public TsOrderIdentity getTsOrderIdentity() {
		return tsOrderIdentity;
	}

	public void setTsOrderIdentity(TsOrderIdentity tsOrderIdentity) {
		this.tsOrderIdentity = tsOrderIdentity;
	}

	public String getTradeNo() {
		return tradeNo;
	}

	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}

	public OrderRedirectVO getRedirect() {
		return redirect;
	}

	public void setRedirect(OrderRedirectVO redirect) {
		this.redirect = redirect;
	}

	public FinalOrderVO getFinalOrderVO() {
		return finalOrderVO;
	}

	public void setFinalOrderVO(FinalOrderVO finalOrderVO) {
		this.finalOrderVO = finalOrderVO;
	}
	
	public String getOutOrderCode() {
		return outOrderCode;
	}

	public void setOutOrderCode(String outOrderCode) {
		this.outOrderCode = outOrderCode;
	}

	public ThirdpartyOrderTypeEnum getThirdpartyOrderTypeEnum() {
		return thirdpartyOrderTypeEnum;
	}

	public void setThirdpartyOrderTypeEnum(ThirdpartyOrderTypeEnum thirdpartyOrderTypeEnum) {
		this.thirdpartyOrderTypeEnum = thirdpartyOrderTypeEnum;
	}

	public List<String> getThirdpartyOrderCodes() {
		return thirdpartyOrderCodes;
	}

	public void setThirdpartyOrderCodes(List<String> thirdpartyOrderCodes) {
		this.thirdpartyOrderCodes = thirdpartyOrderCodes;
	}

	public AccessWayEnum getSoAccessWayEnum() {
		return soAccessWayEnum;
	}

	public void setSoAccessWayEnum(AccessWayEnum soAccessWayEnum) {
		this.soAccessWayEnum = soAccessWayEnum;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this)
				.append("id", id)
				.append("state", state)
				.append("payExpireTime", payExpireTime)
				.append("createTime", createTime)
				.append("payTime", payTime)
				.append("tradeNo", tradeNo)
				.append("price", price)
				.append("packs", packs)
				.append("address", address)
				.append("hasOverseaProducts", hasOverseaProducts)
				.append("payMethods", payMethods)
				.append("orderType", orderType)
				.append("furniture", furniture)
				.append("grouponVO", grouponVO)
				.append("shareOrder", shareOrder)
				.append("redirect", redirect)
				.append("tsOrderIdentity", tsOrderIdentity)
				.toString();
	}
}
