package com.thebeastshop.trans.exception;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * 公司异常框架的根异常。公司内定义的所有业务异常都应该继承自本类。
 *
 * @author Liang Wenjian
 */
public abstract class TsBaseException extends RuntimeException {

	private static final long serialVersionUID = 4904242843495439482L;

	protected transient final Logger logger = LoggerFactory.getLogger(getClass());

	private final String id;

	public TsBaseException(final String message) {
		super(message);
		id = buildId();
	}

	private String buildId() {
		final Thread thread = Thread.currentThread();
		try {
			final InetAddress inetAddress = InetAddress.getLocalHost();
			return thread.getId() + "_" + System.currentTimeMillis() + '_' + inetAddress.getHostAddress();
		} catch (final UnknownHostException e) {
			logger.warn("不应该发生", e);
			return thread.getId() + "_" + System.currentTimeMillis();
		}
	}

	public String getId() {
		return id;
	}


}
