package com.thebeastshop.trans.vo.cart;

import com.google.common.collect.Lists;
import com.thebeastshop.common.BaseDO;
import com.thebeastshop.trans.enums.TsCartPackSourceEnum;
import com.thebeastshop.trans.vo.TsLabelVO;
import com.thebeastshop.trans.vo.campaign.TsPackCampaignVO;
import com.thebeastshop.trans.vo.customize.TsUserSingleCustomizationVO;
import com.thebeastshop.trans.vo.product.TsSpvVO;

import java.util.Collection;
import java.util.List;

/**
 * 商品包
 * 
 * @author Paul-xiong
 *
 */
public class TsCartProductPackVO extends BaseDO {
	/**
	 * 
	 */
	private Long id;
	/**
	 * 数量
	 */
	private int count = 1;
	/**
	 * 商品包来源
	 */
	private TsCartPackSourceEnum source = TsCartPackSourceEnum.RAW;
	/**
	 * 商品code
	 */
	private String productId;
	/**
	 * spv信息
	 */
	private TsSpvVO spv;
	/**
	 * 是否包含规格
	 */
	private boolean hasVariants;
	/**
	 * 标签
	 */
	private Collection<TsLabelVO> labels = Lists.newArrayList();
	/**
	 * 赠品商品
	 */
	private List<TsCartProductPackVO> giftPacks;
	/**
	 * 是否已获得（加价购才有）
	 */
	private Boolean owned = false;
	/**
	 * 是否定制（false未定制 true定制）
	 */
	private Boolean customized = false;
	/**
	 * 定制内容
	 */
	private String customizeInfo;
	/**
	 * 定制属性集
	 */
	private List<TsUserSingleCustomizationVO> customizes;
	/**
	 * 参加的赠品活动
	 */
	private TsPackCampaignVO campaign;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public int getCount() {
		return count;
	}

	public void setCount(int count) {
		this.count = count;
	}

	public TsCartPackSourceEnum getSource() {
		return source;
	}

	public void setSource(TsCartPackSourceEnum source) {
		this.source = source;
	}

	public String getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = productId;
	}

	public TsSpvVO getSpv() {
		return spv;
	}

	public void setSpv(TsSpvVO spv) {
		this.spv = spv;
	}

	public boolean isHasVariants() {
		return hasVariants;
	}

	public void setHasVariants(boolean hasVariants) {
		this.hasVariants = hasVariants;
	}

	public Collection<TsLabelVO> getLabels() {
		return labels;
	}

	public void setLabels(Collection<TsLabelVO> labels) {
		this.labels = labels;
	}

	public List<TsCartProductPackVO> getGiftPacks() {
		return giftPacks;
	}

	public void setGiftPacks(List<TsCartProductPackVO> giftPacks) {
		this.giftPacks = giftPacks;
	}

	public Boolean getOwned() {
		return owned;
	}

	public void setOwned(Boolean owned) {
		this.owned = owned;
	}

	public Boolean getCustomized() {
		return customized;
	}

	public void setCustomized(Boolean customized) {
		this.customized = customized;
	}

	public String getCustomizeInfo() {
		return customizeInfo;
	}

	public void setCustomizeInfo(String customizeInfo) {
		this.customizeInfo = customizeInfo;
	}

	public List<TsUserSingleCustomizationVO> getCustomizes() {
		return customizes;
	}

	public void setCustomizes(List<TsUserSingleCustomizationVO> customizes) {
		this.customizes = customizes;
	}

	public TsPackCampaignVO getCampaign() {
		return campaign;
	}

	public void setCampaign(TsPackCampaignVO campaign) {
		this.campaign = campaign;
	}

	@Override
	public String toString() {
		final StringBuffer sb = new StringBuffer("TsCartProductPackVO{");
		sb.append("id=").append(id);
		sb.append(", count=").append(count);
		sb.append(", source=").append(source);
		sb.append(", productId='").append(productId).append('\'');
		sb.append(", spv=").append(spv);
		sb.append(", hasVariants=").append(hasVariants);
		sb.append(", labels=").append(labels);
		sb.append(", owned=").append(owned);
		sb.append(", customized=").append(customized);
		sb.append(", customizeInfo='").append(customizeInfo).append('\'');
		sb.append(", customizes=").append(customizes);
		sb.append('}');
		return sb.toString();
	}

}
