package com.thebeastshop.trans.enums;

public enum TsrOrderInvoiceEnum {
	
	UN_INVOICE(0,"不能开发票",""),
	NOT_INVOICE(1,"未开发票",""),
	CHECK_INVOICE(2,"查看发票","");

	private int code;
	private String name;
	private String url;
	
	
	
	public String getUrl() {
		return url;
	}
	TsrOrderInvoiceEnum(Integer code, String name,String url) {
		this.code = code;
		this.name = name;
		this.url = url;
	}

	public Integer getCode() {
		return code;
	}
	
	public String getName(){
		return name;
	}

	public static TsrOrderInvoiceEnum getEnumByCode(Integer code) {
		for (TsrOrderInvoiceEnum e : TsrOrderInvoiceEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}
}
