package com.thebeastshop.trans.vo.product;

import com.thebeastshop.trans.vo.TsLabelVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 商品详细
 * 
 * @author Paul-xiong
 *
 */
public class TsProductVO {
	private TsSimpleProductVO raw = new TsSimpleProductVO();
	/**
	 * 徽章
	 */
	private List<TsProductBadgeVO> badges = new ArrayList<TsProductBadgeVO>();
	/**
	 * 是否需要验证地址
	 */
	private boolean needVerifyAddress = false;
	/**
	 * 提示
	 */
	private List<TsProductTipVO> tips = new ArrayList<TsProductTipVO>();
	/**
	 * 规格
	 */
	private TsProductVariantVO variant = new TsProductVariantVO();
	/**
	 * 分享
	 */
	private TsProductShareVO share = new TsProductShareVO();
	/**
	 * 是否收藏
	 */
	private Boolean favorited = false;
	/**
	 * 商品是否可定制
	 */
	private Boolean customizable = false;

	/**
	 * 月送
	 */
	private Boolean monthSend = false;

	/**
	 * 该商品页是否使用 HTML 代替。定制商品为true
	 */
	private Boolean useHTML = false;
	/**
	 * 是否为预售商品，若不是预售，则为 null
	 */
	private TsPreSellVO presell;

	/**
	 * 水印图标
	 */
	private String waterMarkImage;

	private TsPriceForecastVO priceForecast;

	private Boolean buyable;

	public Boolean getBuyable() {
		return buyable;
	}

	public void setBuyable(Boolean buyable) {
		this.buyable = buyable;
	}

	public TsPriceForecastVO getPriceForecast() {
		return priceForecast;
	}

	public void setPriceForecast(TsPriceForecastVO priceForecast) {
		this.priceForecast = priceForecast;
	}

	public TsProductVO() {
		super();
	}

	public TsProductVO(TsSimpleProductVO raw) {
		this.raw = raw;
	}

	public TsDiscVO getDiscount() {
		return raw.getDiscount();
	}

	public void setDiscount(TsDiscVO discount) {
		raw.setDiscount(discount);
	}

	public String getFeatureImage() {
		return raw.getFeatureImage();
	}

	public void setFeatureImage(String featureImage) {
		raw.setFeatureImage(featureImage);
	}

	public String getId() {
		return raw.getId();
	}

	public TsBrandVO getBrand() {
		return raw.getBrand();
	}

	public String getName() {
		return raw.getName();
	}

	public String getSummary() {
		return raw.getSummary();
	}

	public BigDecimal getRawPrice() {
		return raw.getRawPrice();
	}

	public BigDecimal getPrice() {
		return raw.getPrice();
	}

	public Boolean getSoldOut() {
		return raw.getSoldOut();
	}

	public Boolean getInvisible() {
		return raw.getInvisible();
	}

	public void setInvisible(Boolean invisible) {
		raw.setInvisible(invisible);
	}

	public Boolean getOffShelf() {
		return raw.getOffShelf();
	}

	public void setOffShelf(Boolean offShelf) {
		raw.setOffShelf(offShelf);
	}

	public List<TsLabelVO> getLabels() {
		return raw.getLabels();
	}

	public void setLabels(List<TsLabelVO> labels) {
		raw.setLabels(labels);
	}

	public List<TsProductBadgeVO> getBadges() {
		return badges;
	}

	public List<TsProductTipVO> getTips() {
		return tips;
	}

	public TsProductVariantVO getVariant() {
		return variant;
	}

	public void setId(String id) {
		raw.setId(id);
	}

	public List<String> getImages() {
		return raw.getImages();
	}

	public void setImages(List<String> images) {
		raw.setImages(images);
	}

	public void setBrand(TsBrandVO brand) {
		raw.setBrand(brand);
	}

	public void setName(String name) {
		raw.setName(name);
	}

	public void setSummary(String summary) {
		raw.setSummary(summary);
	}

	public void setRawPrice(BigDecimal rawPrice) {
		raw.setRawPrice(rawPrice);
	}

	public void setPrice(BigDecimal price) {
		raw.setPrice(price);
	}

	public void setSoldOut(Boolean soldOut) {
		raw.setSoldOut(soldOut);
	}

	public Boolean getFavorited() {
		return favorited;
	}

	public TsProductShareVO getShare() {
		return share;
	}

	public void setShare(TsProductShareVO share) {
		this.share = share;
	}

	public void setFavorited(Boolean favorited) {
		this.favorited = favorited;
	}

	public boolean isNeedVerifyAddress() {
		return needVerifyAddress;
	}

	public void setNeedVerifyAddress(boolean needVerifyAddress) {
		this.needVerifyAddress = needVerifyAddress;
	}

	public void setBadges(List<TsProductBadgeVO> badges) {
		this.badges = badges;
	}

	public void setTips(List<TsProductTipVO> tips) {
		this.tips = tips;
	}

	public void setVariant(TsProductVariantVO variant) {
		this.variant = variant;
	}

	public String getWaterMarkImage() {
		return waterMarkImage;
	}

	public void setWaterMarkImage(String waterMarkImage) {
		this.waterMarkImage = waterMarkImage;
	}

	public TsPreSellVO getPresell() {
		return presell;
	}

	public void setPresell(TsPreSellVO presell) {
		this.presell = presell;
	}

	public Boolean getCustomizable() {
		return customizable;
	}

	public void setCustomizable(Boolean customizable) {
		this.customizable = customizable;
	}

	public Boolean getUseHTML() {
		return useHTML;
	}

	public void setUseHTML(Boolean useHTML) {
		this.useHTML = useHTML;
	}

	public Boolean getMonthSend() {
		return monthSend;
	}

	public void setMonthSend(Boolean monthSend) {
		this.monthSend = monthSend;
	}

	@Override
	public String toString() {
		final StringBuffer sb = new StringBuffer("ProductVO{");
		sb.append("raw=").append(raw);
		sb.append(", badges=").append(badges);
		sb.append(", needVerifyAddress=").append(needVerifyAddress);
		sb.append(", tips=").append(tips);
		sb.append(", variant=").append(variant);
		sb.append(", share=").append(share);
		sb.append(", favorited=").append(favorited);
		sb.append(", customizable=").append(customizable);
		sb.append(", useHTML=").append(useHTML);
		sb.append(", presell=").append(presell);
		sb.append(", waterMarkImage='").append(waterMarkImage).append('\'');
		sb.append(", priceForecast=").append(priceForecast);
		sb.append(", buyable=").append(buyable);
		sb.append('}');
		return sb.toString();
	}
}
