/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.trans.vo.order;

import com.google.common.collect.Lists;
import com.thebeastshop.common.BaseDO;
import com.thebeastshop.trans.enums.TsPaymentTypeEnum;
import com.thebeastshop.trans.vo.TsLabelVO;
import com.thebeastshop.trans.vo.cart.TsCartProductPackVO;
import com.thebeastshop.trans.vo.logistics.TsDateUnitVO;
import com.thebeastshop.trans.vo.logistics.TsPostageVO;
import com.thebeastshop.trans.vo.logistics.TsTimeSlotVO;
import com.thebeastshop.trans.vo.member.TsMemberAddressVO;
import com.thebeastshop.trans.vo.price.TsPriceStepVO;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

/**
 * 预览订单
 * 
 * @author Paul-xiong
 *
 */
public class TsOrderConfirmVO extends BaseDO {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 价格
	 */
	private BigDecimal price;

	/**
	 * 定制费用
	 */
	private BigDecimal customizePrice;
	/**
	 * 商品包
	 */
	private Collection<TsCartProductPackVO> packs = Lists.newArrayList();
	/**
	 * 标签
	 */
	private Collection<TsLabelVO> labels = Lists.newArrayList();
	/**
	 * 是否包含海外购商品
	 */
	private boolean hasOverseaProducts = false;
	/**
	 * 价格步骤
	 */
	private Collection<TsPriceStepVO> priceSteps;
	/**
	 * 地址信息
	 */
	private TsMemberAddressVO address;
	/**
	 * 配送描述
	 */
	private String deliveryTip;
	/**
	 * 可配送日期
	 */
	private List<TsDateUnitVO> deliverableDates;
	/**
	 * 时段
	 */
	private List<TsTimeSlotVO> deliverableTimeSlots;
	/**
	 * 邮费
	 */
	private TsPostageVO postage;
	/**
	 * 是否可以使用生日折扣
	 */
	private TsBdayVO bday;
	/**
	 * 可用的支付方式
	 */
	private List<TsPaymentTypeEnum> payMethods;

	/**
	 * 是否可以添加备注
	 */
	private Boolean canRemark;

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public Collection<TsCartProductPackVO> getPacks() {
		return packs;
	}

	public void setPacks(Collection<TsCartProductPackVO> packs) {
		this.packs = packs;
	}

	public boolean isHasOverseaProducts() {
		return hasOverseaProducts;
	}

	public void setHasOverseaProducts(boolean hasOverseaProducts) {
		this.hasOverseaProducts = hasOverseaProducts;
	}

	public Collection<TsPriceStepVO> getPriceSteps() {
		return priceSteps;
	}

	public void setPriceSteps(Collection<TsPriceStepVO> priceSteps) {
		this.priceSteps = priceSteps;
	}

	public TsMemberAddressVO getAddress() {
		return address;
	}

	public void setAddress(TsMemberAddressVO address) {
		this.address = address;
	}

	public String getDeliveryTip() {
		return deliveryTip;
	}

	public void setDeliveryTip(String deliveryTip) {
		this.deliveryTip = deliveryTip;
	}

	public List<TsDateUnitVO> getDeliverableDates() {
		return deliverableDates;
	}

	public void setDeliverableDates(List<TsDateUnitVO> deliverableDates) {
		this.deliverableDates = deliverableDates;
	}

	public List<TsTimeSlotVO> getDeliverableTimeSlots() {
		return deliverableTimeSlots;
	}

	public void setDeliverableTimeSlots(List<TsTimeSlotVO> deliverableTimeSlots) {
		this.deliverableTimeSlots = deliverableTimeSlots;
	}

	public TsBdayVO getBday() {
		return bday;
	}

	public void setBday(TsBdayVO bday) {
		this.bday = bday;
	}

	public Collection<TsLabelVO> getLabels() {
		return labels;
	}

	public void setLabels(Collection<TsLabelVO> labels) {
		this.labels = labels;
	}

	public TsPostageVO getPostage() {
		return postage;
	}

	public void setPostage(TsPostageVO postage) {
		this.postage = postage;
	}

	public List<TsPaymentTypeEnum> getPayMethods() {
		return payMethods;
	}

	public void setPayMethods(List<TsPaymentTypeEnum> payMethods) {
		this.payMethods = payMethods;
	}

	public Boolean getCanRemark() {
		return canRemark;
	}

	public void setCanRemark(Boolean canRemark) {
		this.canRemark = canRemark;
	}

	public BigDecimal getCustomizePrice() {
		return customizePrice;
	}

	public void setCustomizePrice(BigDecimal customizePrice) {
		this.customizePrice = customizePrice;
	}

	@Override
	public String toString() {
		final StringBuffer sb = new StringBuffer("TsOrderConfirmVO{");
		sb.append("price=").append(price);
		sb.append(", customizePrice=").append(customizePrice);
		sb.append(", packs=").append(packs);
		sb.append(", labels=").append(labels);
		sb.append(", hasOverseaProducts=").append(hasOverseaProducts);
		sb.append(", priceSteps=").append(priceSteps);
		sb.append(", address=").append(address);
		sb.append(", deliveryTip='").append(deliveryTip).append('\'');
		sb.append(", deliverableDates=").append(deliverableDates);
		sb.append(", deliverableTimeSlots=").append(deliverableTimeSlots);
		sb.append(", postage=").append(postage);
		sb.append(", bday=").append(bday);
		sb.append(", payMethods=").append(payMethods);
		sb.append(", canRemark=").append(canRemark);
		sb.append('}');
		return sb.toString();
	}


}
