package com.thebeastshop.trans.enums;

/**
 * t_op_so_package表 PACKAGE_STATUS字段
 * @author donghui
 */
public enum TsSoPackageStatusEnum {
    UNSENT_CANCEL(-1, "未发货取消"),
    DEFAULT_HAND(1, "初始挂起"),
    MAKE_HAND(2, "制单挂起"),
    DEFAULT(10, "初始"),
    WAITING_MAKE(11, "待制单"),
    WAITING_SEND(12, "待发货"),
    WAITING_RECEIVE(13, "待收货"),
    ALREADY_RECEIVE(14, "已收货"),
    ALREADY_OUT(15, "已出库");
    
    public Integer code;
    public String cn;
	private TsSoPackageStatusEnum(Integer code, String cn) {
		this.code = code;
		this.cn = cn;
	}


	public static TsSoPackageStatusEnum getEnumByCode(Integer code) {
		for (TsSoPackageStatusEnum e : TsSoPackageStatusEnum.values()) {
			if (e.code == code) {
				return e;
			}
		}
		return null;
	}
}
