package com.thebeastshop.trans.enums;

/**
 * t_op_sales_order表SALES_ORDER_TYPE字段 订单类型
 * @author donghui
 */
public enum TsSalesOrderTypeEnum {
	SALES(1, "渠道销售单"),
	EXCHANGE(2, "渠道换货单"),
	GROUP(3, "集团订单"),
	REPLENISH(4, "渠道补货单"),
	GIFT(11, "礼品订单"),
	SAMPLE(12, "样品订单"),
	THIRD(13, "第三方订单");
	
	public Integer code;
	public String cn;
	
	private TsSalesOrderTypeEnum(Integer code, String cn) {
		this.code = code;
		this.cn = cn;
	}
	
	public static TsSalesOrderTypeEnum getEnumByCode(Integer code) {
		for (TsSalesOrderTypeEnum e : TsSalesOrderTypeEnum.values()) {
			if (e.code == code) {
				return e;
			}
		}
		return null;
	}
}
