package com.thebeastshop.trans.enums;

public enum TsReturnRefundStatusEnum {
	
    WAIT_FOR_REFUND(1, "待退款"),
    FINISHED(2, "已退款");
	
	public Integer code;
	public String cn;
	
	private TsReturnRefundStatusEnum(Integer code, String cn) {
		this.code = code;
		this.cn = cn;
	}

	public static TsReturnRefundStatusEnum getEnumByCode(Integer code) {
		for (TsReturnRefundStatusEnum e : TsReturnRefundStatusEnum.values()) {
			if (e.code == code) {
				return e;
			}
		}
		return null;
	}
}
