package com.thebeastshop.trans.enums;

public enum TsRefundTypeEnum {

    REFUND(1, "仅退款"),
    RETURN(2, "退货退款"),
    EXCHANGE(3, "换货"),

    ;

    private final Integer code;
    private final String cn;

    TsRefundTypeEnum(Integer code, String cn) {
        this.code = code;
        this.cn = cn;
    }

    public static TsRefundTypeEnum getByCode(Integer code) {
        for (TsRefundTypeEnum value : values()) {
            if (value.getCode().equals(code))
                return value;
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getCn() {
        return cn;
    }
}
