package com.thebeastshop.trans.vo.order;

import java.io.Serializable;
import java.util.List;

/**
 * @ClassName: OrderCustomCardVO
 * @Description: 定制卡片
 * @author: Xiang.Gao
 * @date: 2020/11/10 15:26
 */
public class OrderCustomCardVO implements Serializable {

    private static final long serialVersionUID = 1L;

    public interface CardStyle{
        //BASE-普通样式 LOVER-情人节样式;
        String BASE = "BASE";
        String LOVER = "LOVER";
        String C202201 = "C202201";             //椭圆粉色贴纸
        String C202202 = "C202202";             //方形散香器贴纸（小）
        String C202203 = "C202203";             //方形散香器贴纸（大）
    }

    /**
     * 是否可编辑
     */
    private Boolean canCustom;

    /**
     * 是否已定制
     */
    private Boolean customized;

    private String cardStyle=CardStyle.BASE;
    /**
     * 总数
     */
    private Integer total;

    /**
     * 空白卡片数
     */
    private Integer blankNum;

    /**
     * 代写卡片数
     */
    private Integer writeNum;

    /**
     * 卡片集合
     */
    private List<OrderCardVO> cards;

    public Boolean getCanCustom() {
        return canCustom;
    }

    public void setCanCustom(Boolean canCustom) {
        this.canCustom = canCustom;
    }

    public Boolean getCustomized() {
        return customized;
    }

    public void setCustomized(Boolean customized) {
        this.customized = customized;
    }

    public String getCardStyle() {
        return cardStyle;
    }

    public void setCardStyle(String cardStyle) {
        this.cardStyle = cardStyle;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getBlankNum() {
        return blankNum;
    }

    public void setBlankNum(Integer blankNum) {
        this.blankNum = blankNum;
    }

    public Integer getWriteNum() {
        return writeNum;
    }

    public void setWriteNum(Integer writeNum) {
        this.writeNum = writeNum;
    }

    public List<OrderCardVO> getCards() {
        return cards;
    }

    public void setCards(List<OrderCardVO> cards) {
        this.cards = cards;
    }

    @Override
    public String toString() {
        return "OrderCustomCardVO{" +
                "canCustom=" + canCustom +
                ", customized=" + customized +
                ", total=" + total +
                ", blankNum=" + blankNum +
                ", writeNum=" + writeNum +
                ", cards=" + cards +
                '}';
    }
}
