package com.thebeastshop.trans.enums;

public enum TsPriceTypeEnum {
	/**
	 * 会员折扣
	 */
	MEMBER_LEVEL(1, "会员折扣"),
	/**
	 * 活动
	 */
	CAMPAIGN(2, "活动"),
	/**
	 * 优惠券
	 */
	COUPON(3, "优惠券"),
	/**
	 * 生日折扣
	 */
	BIRTHDAY(4, "生日折扣"),
	/**
	 * 礼品卡折扣
	 */
	GIFTCARD(5, "礼品卡"),
	/**
	 * 运费
	 */
	POSTAGE(6, "运费"),
	/**
	 * 海淘运费
	 */
	OVERSEAS(7, "海淘运费"),
	/**
	 * 定制费
	 */
	CUSTOMIZE(8, "定制费"),
	/**
	 * 精确时段配送费
	 */
	TIME(9, "精确时段配送费"),
	;
	
	private Integer code;
	
	private String name;

	TsPriceTypeEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}
	
	public String getName(){
		return name;
	}

	public static TsPriceTypeEnum getEnumByCode(Integer code) {
		for (TsPriceTypeEnum e : TsPriceTypeEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}
	
	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
