package com.thebeastshop.trans.enums;

public enum TsDeliveryTypeEnum {
	SF(0, "顺丰"), 
	SELF(1, "自送"), 
	FEDEX(2, "联邦");
	
	private Integer code;
	
	private String name;
	

	TsDeliveryTypeEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}
	
	public String getName(){
		return name;
	}
	
	public static TsDeliveryTypeEnum getEnumByCode(Integer code) {
		for (TsDeliveryTypeEnum e : TsDeliveryTypeEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}
	
	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
