package com.thebeastshop.trans.dto;

import java.math.BigDecimal;
import java.util.List;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.trans.vo.cart.TsCartProductPackVO;

/**
 * <p>Title: thebeastshop</p>
 * <p>Copyright: Copyright (c) 2016</p>
 * @author Bryan Zhang
 * @date 2017-2-17
 * @description 
 */
public class TsOrderConfirmDTO extends BaseDO {

	private static final long serialVersionUID = 1L;
	
	private AccessWayEnum accessWay;
	
	private String code;
	
	private Integer memberId;
	
	/**
	 * 商品包
	 */
	private List<TsCartProductPackVO> packs;
	/**
	 * 地址id
	 */
	private Integer addressId;
	/**
	 * 配送日期
	 */
	private String deliveryDate;
	/**
	 * 配送时段
	 */
	private int deliveryTimeSlot;
	/**
	 * 卡片
	 */
	private String card;
	/**
	 * 是否为匿名购买
	 */
	private boolean anonymous = true;
	/**
	 * 是否使用生日折扣
	 */
	private boolean useBdayDiscount = false;
	/**
	 * 优惠券id
	 */
	private Integer couponId;
	/**
	 * 支付金额
	 */
	private BigDecimal price;
	/**
	 * APP下载来源
	 */
	private String downloadSource;

	/**
	 * 订单备注
	 */
	private String remark;

	public List<TsCartProductPackVO> getPacks() {
		return packs;
	}

	public void setPacks(List<TsCartProductPackVO> packs) {
		this.packs = packs;
	}

	public Integer getAddressId() {
		return addressId;
	}

	public void setAddressId(Integer addressId) {
		this.addressId = addressId;
	}

	public String getDeliveryDate() {
		return deliveryDate;
	}

	public void setDeliveryDate(String deliveryDate) {
		this.deliveryDate = deliveryDate;
	}

	public int getDeliveryTimeSlot() {
		return deliveryTimeSlot;
	}

	public void setDeliveryTimeSlot(int deliveryTimeSlot) {
		this.deliveryTimeSlot = deliveryTimeSlot;
	}

	public String getCard() {
		return card;
	}

	public void setCard(String card) {
		this.card = card;
	}

	public boolean isAnonymous() {
		return anonymous;
	}

	public void setAnonymous(boolean anonymous) {
		this.anonymous = anonymous;
	}

	public boolean isUseBdayDiscount() {
		return useBdayDiscount;
	}

	public void setUseBdayDiscount(boolean useBdayDiscount) {
		this.useBdayDiscount = useBdayDiscount;
	}

	public Integer getCouponId() {
		return couponId;
	}

	public void setCouponId(Integer couponId) {
		this.couponId = couponId;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public String getDownloadSource() {
		return downloadSource;
	}

	public void setDownloadSource(String downloadSource) {
		this.downloadSource = downloadSource;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Integer getMemberId() {
		return memberId;
	}

	public void setMemberId(Integer memberId) {
		this.memberId = memberId;
	}

	public AccessWayEnum getAccessWay() {
		return accessWay;
	}

	public void setAccessWay(AccessWayEnum accessWay) {
		this.accessWay = accessWay;
	}
	
}
