package com.thebeastshop.trans.vo.customize;

import com.thebeastshop.common.BaseDO;

import java.io.Serializable;
import java.util.List;

/**
 * 定制维度
 * Created by feilong.gao on 2016/12/12.
 */
public class TsCustomDimensionVO extends BaseDO {


    private static final long serialVersionUID = -7232604886622003044L;
    /**
     * 定制元素id
     */
    private Long id;

    /**
     * 定制元素id
     */
    private Long parentId;

    /**
     * 定制元素名字
     */
    private String name;
    /**
     * 定制元素类型:<SELECT|INPUT>
     */
    private String type;
    /**
     * 定制元素Icon图片
     */
    private String icon;
    /**
     * 定制属性选项列表
     */
    private List<TsCustomChoiceVO> choices;
    /**
     * type= input时输入框显示信息
     */
    private String placeholder;
    /**
     * 支持类型(1:字母;2:数字;3:表情）
     */
    private String supportType;
    /**
     * 字数限制
     */
    private Integer wordlimit;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<TsCustomChoiceVO> getChoices() {
        return choices;
    }

    public void setChoices(List<TsCustomChoiceVO> choices) {
        this.choices = choices;
    }

    public String getPlaceholder() {
        return placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public String getSupportType() {
        return supportType;
    }

    public void setSupportType(String supportType) {
        this.supportType = supportType;
    }

    public Integer getWordlimit() {
        return wordlimit;
    }

    public void setWordlimit(Integer wordlimit) {
        this.wordlimit = wordlimit;
    }

    @Override
    public String toString() {
        final StringBuffer sb = new StringBuffer("TsCustomDimensionVO{");
        sb.append("id=").append(id);
        sb.append(", parentId=").append(parentId);
        sb.append(", name='").append(name).append('\'');
        sb.append(", type='").append(type).append('\'');
        sb.append(", icon='").append(icon).append('\'');
        sb.append(", choices=").append(choices);
        sb.append(", placeholder='").append(placeholder).append('\'');
        sb.append(", supportType='").append(supportType).append('\'');
        sb.append(", wordlimit=").append(wordlimit);
        sb.append('}');
        return sb.toString();
    }
}
