package com.thebeastshop.trans.vo.order;

import com.thebeastshop.common.BaseDO;

import java.math.BigDecimal;

/**
 * 生日折扣
 *
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-03-03 18:10
 */
public class TsBdayVO extends BaseDO {

    /**
     * 是否在生日折扣可以使用的期间内
     */
    private boolean within;
    /**
     * 今年是否已经使用过
     */
    private boolean used;
    /**
     * 折扣率
     */
    private BigDecimal ratio;

    public boolean isWithin() {
        return within;
    }

    public void setWithin(boolean within) {
        this.within = within;
    }

    public boolean isUsed() {
        return used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public BigDecimal getRatio() {
        return ratio;
    }

    public void setRatio(BigDecimal ratio) {
        this.ratio = ratio;
    }

    @Override
    public String toString() {
        return "BdayVO [within=" + within + ", used=" + used + ", ratio=" + ratio + "]";
    }

}
