/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.trans.exception;

import com.google.common.collect.Sets;
import com.thebeastshop.trans.exception.TsExceptionUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TsBaseException
extends RuntimeException {
    public static final Collection<String> NEXT_STEP_IDS_OF_RETRY = Collections.singleton("self");
    public static final Collection<String> NEXT_STEP_IDS_OF_REPORT_PROBLEM = Collections.singleton("reportProblem");
    public static final Collection<String> NEXT_STEP_IDS_OF_RETRY_OR_REPORT_BUG = Sets.newHashSet((Object[])new String[]{"self", "reportProblem"});
    public static final Collection<String> NEXT_STEP_IDS_OF_PLAT_AUTHORIZE = Collections.singleton("platAuthorize");
    private static final long serialVersionUID = 4904242843495439482L;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String id;
    private final Collection<String> nextStepIds;

    public static TsBaseException findBaseException(Throwable throwable) {
        return TsExceptionUtil.findCause(throwable, TsBaseException.class, true);
    }

    public TsBaseException(String message) {
        super(message);
        this.id = this.buildId();
        this.nextStepIds = NEXT_STEP_IDS_OF_REPORT_PROBLEM;
    }

    public TsBaseException(String message, Collection<String> nextStepIds) {
        super(message);
        this.id = this.buildId();
        this.nextStepIds = Collections.unmodifiableCollection(nextStepIds);
    }

    public TsBaseException(String message, Throwable cause) {
        super(message, cause);
        if (cause instanceof TsBaseException) {
            TsBaseException baseException = (TsBaseException)cause;
            this.id = baseException.getId();
        } else {
            this.id = this.buildId();
        }
        this.nextStepIds = Collections.emptyList();
    }

    private String buildId() {
        Thread thread = Thread.currentThread();
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return thread.getId() + "_" + System.currentTimeMillis() + '_' + inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            this.logger.warn("\u4e0d\u5e94\u8be5\u53d1\u751f", (Throwable)e);
            return thread.getId() + "_" + System.currentTimeMillis();
        }
    }

    public String getId() {
        return this.id;
    }

    public TsBaseException(String message, Throwable cause, Collection<String> nextStepIds) {
        super(message, cause);
        if (cause instanceof TsBaseException) {
            TsBaseException baseException = (TsBaseException)cause;
            this.id = baseException.getId();
        } else {
            this.id = this.buildId();
        }
        this.nextStepIds = Collections.unmodifiableCollection(nextStepIds);
    }

    public Collection<String> getNextStepIds() {
        return this.nextStepIds;
    }
}

