package com.thebeastshop.trans.vo.price;

import com.thebeastshop.common.BaseDO;

import java.math.BigDecimal;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-03-03 17:55
 */
public class TsPriceStepVO extends BaseDO {

    /**
     * 名字
     */
    private String name;
    /**
     * 价格
     */
    private BigDecimal price;
    /**
     * 描述
     */
    private String desc;

    /**
     * 步骤类型
     */
    private Integer stepType;

    public TsPriceStepVO() {
        super();
    }

    public TsPriceStepVO(String name, BigDecimal price) {
        super();
        this.name = name;
        this.price = price;
    }

    public TsPriceStepVO(String name, BigDecimal price, String desc) {
        this(name, price);
        this.desc = desc;
    }

    public TsPriceStepVO(String name, BigDecimal price, Integer stepType) {
        this(name, price);
        this.stepType = stepType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getStepType() {
        return stepType;
    }

    public void setStepType(Integer stepType) {
        this.stepType = stepType;
    }

    @Override
    public String toString() {
        return "TsPriceStepVO{" +
                "name='" + name + '\'' +
                ", price=" + price +
                ", desc='" + desc + '\'' +
                ", stepType=" + stepType +
                '}';
    }

}
