package com.thebeastshop.trans.enums;

public enum TsPaymentTypeEnum {
	CUSTOMER_SERVICE(0, "客服"),
    CASH(1, "现金"),
    DEBIT_CARD(2, "借记卡"),
    CREDIT_CARD(3, "信用卡"),
    WEIXIN(4, "微信"),
    ALIPAY(5, "支付宝"),
    CMB(6, "招行"),
    TRANSFER(7, "转账"),
    YCK(8, "预存款"),
	GIFT_CARD(10, "礼品卡")
	;
	
	private Integer code;
	
	private String name;

	TsPaymentTypeEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}
	
	public String getName(){
		return name;
	}

	public static TsPaymentTypeEnum getEnumByCode(Integer code) {
		for (TsPaymentTypeEnum e : TsPaymentTypeEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}
	
	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
