package com.thebeastshop.trans.enums;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-20 14:49
 */
public enum TsOrderPackSourceEnum {
    /**
     * 来自用户自购
     */
    RAW(0, "自购"),
    /**
     * 来自赠品
     */
    GIFT(3, "买赠"),
    /**
     * 来自加价购（也是用户自主点击了购买的）
     */
    CHEAPEN_OTHER(4, "加价购");

    public final Integer id;
    public final String name;

    private TsOrderPackSourceEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }


}
