package com.thebeastshop.stock.dto;

import com.thebeastshop.stock.vo.SStockChannelVO;

import java.util.List;

/**
 * iPos 渠道下的 SPV 库存明细查询对象接口
 *
 * @author Jun.Gong [jun.gong@thebeastshop.com]
 * @see SIPosSpvCombinedStockDetailQueryDTO
 * @see SIPosSpvStockDetailQueryDTO
 * @since 1.7.6
 */
public interface SIPosSpuStockDetailQuery {

    String getProdCode();

    /**
     * 获取配送仓渠道列表
     * @return 配送仓渠道 {@link SStockChannelVO} 对象列表
     */
    List<SStockChannelVO> getDispatchChannels();

}
