package com.thebeastshop.stock.service;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.stock.dto.SFlowerMonStockOccupyDTO;
import com.thebeastshop.stock.dto.SFlowerMonthlyCityDTO;
import com.thebeastshop.stock.dto.SFlowerMonthlyQueryDTO;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.enums.SFlowerProductionTypeEnum;
import com.thebeastshop.stock.vo.SOccupyResultVO;

import java.util.List;

/**
 * 月送鲜花库存服务
 */
public interface SFlowerMonthlyService {

  /**
   * 获取月送鲜花sku库存
   * @param skuCode
   * @param cityId
   * @return
   */
  ServiceResp<SFlowerMonthlyCityDTO> getFlowerSkuStock(String skuCode, Integer cityId, SFlowerProductionTypeEnum sFlowerProductionTypeEnum);

  List<SFlowerMonthlyCityDTO> getFlowerSkuCapaInfo(SFlowerMonthlyQueryDTO queryDTO);

  SFlowerMonthlyCityDTO getFlowerMonWhData(String skuCode);

  /**
   * 实时刷新缓存
   * @param list
   */
  void refreshCache(List<SFlowerMonthlyCityDTO> list);

  void  refreshCacheBySkuCode(String skuCode, SFlowerProductionTypeEnum sFlowerProductionTypeEnum);


  ServiceResp<List<SOccupyResultVO>> occupy(List<SFlowerMonStockOccupyDTO> occupyDTO);

  List<SFlowerMonthlyCityDTO> getFlowerSkuStock(List<SFlowerMonthlyQueryDTO> queryDTOList);

  List<SFlowerMonthlyCityDTO> getCityList(List<String> skuCodes);

}
