package com.thebeastshop.stock.enums;

public enum SGenderEnum {
	MALE(1,"男性"),
    FEMALE(2,"女性"),
    SECRET(3,"保密"),
	;
	
	private Integer code;
	
	private String name;

	SGenderEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}
	
	public String getName(){
		return name;
	}

	public static SCancelEnum getEnumByCode(Integer code) {
		for (SCancelEnum e : SCancelEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}
	
	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
