package com.thebeastshop.stock.enums;

/**
 * Created by libin.kang on 2017/2/4.
 */
public enum SPresaleChannelTypeEnum {
	CHANNEL_TYPE_BEAST(0,"预售渠道：官网"),
	CHANNEL_TYPE_THIRDPARTY(1,"预售渠道：第三方"),
	CHANNEL_TYPE_TMALL(10,"预售渠道：天猫"),
	CHANNEL_TYPE_JD(11,"预售渠道：京东"),
	CHANNEL_TYPE_TMALL_JIAFANG(12,"预售渠道：天猫家纺"),
	CHANNEL_TYPE_OFFLINE(13,"预售渠道：线下"),
    CHANNEL_TYPE_TMALL_HOME(14,"预售渠道：天猫Home"),
    CHANNEL_TYPE_JD_HOME(15,"预售渠道：京东Home"),
    CHANNEL_TYPE_TMALL_NAKED(16,"预售渠道：天猫Naked"),
    CHANNEL_TYPE_TMALL_LITTLEB(17,"预售渠道：天猫LittleB")
    ;

    private Integer code;

    private String name;

    SPresaleChannelTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName(){
        return name;
    }

    public static SGenderEnum getEnumByCode(Integer code) {
        for (SGenderEnum e : SGenderEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getCode().toString();
    }
}
