package com.thebeastshop.stock.enums;

import com.thebeastshop.common.enums.CodeEnum;

public enum SOccupyModeEnum implements CodeEnum<String> {
    DEFAULT("default", "默认占用", SStockOccupyTypeEnum.GROUP_BUY_DEFAULT, SStockOperationTypeEnum.DEFAULT, SStockOccupyTypeEnum.SALES_OUT),
    PRESALE("presale", "预售占用", SStockOccupyTypeEnum.GROUP_BUY_PRESALE, SStockOperationTypeEnum.PRESALE, SStockOccupyTypeEnum.SALES_OUT)
    ;

    private String code;

    private String name;

    private SStockOperationTypeEnum operationType;

    private SStockOccupyTypeEnum occupyType;

    private SStockOccupyTypeEnum groupbuyOccupyType;

    SOccupyModeEnum(String code, String name, SStockOccupyTypeEnum groupbuyOccupyType, SStockOperationTypeEnum operationType, SStockOccupyTypeEnum occupyType) {
        this.code = code;
        this.name = name;
        this.groupbuyOccupyType = groupbuyOccupyType;
        this.operationType = operationType;
        this.occupyType = occupyType;
    }

    public String getCode() {
        return code;
    }

    public String getName(){
        return name;
    }

    public SStockOccupyTypeEnum getGroupbuyOccupyType() {
        return groupbuyOccupyType;
    }

    public SStockOperationTypeEnum getOperationType() {
        return operationType;
    }

    public SStockOccupyTypeEnum getOccupyType() {
        return occupyType;
    }

    public static SOccupyModeEnum getEnumByCode(String code) {
        for (SOccupyModeEnum e : SOccupyModeEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getCode().toString();
    }
}
