package com.thebeastshop.stock.enums;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-08-17 18:57
 */
public enum SStockOperationTypeEnum {

    DEFAULT(0, "默认占用"),

    PRESALE(1, "预售下单占用"),

    PREPARED(2, "预备库存下单占用"),

    JIT(3, "来单制作占用"),

    FLOMER_MONTHLY(4, " 月送鲜花占用"),

//    JIT_CUSTOM(4, "来单定制配方占用")

    GROUP_BUY(5, "拼团占用");


    private Integer id;

    private String name;

    SStockOperationTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public boolean equals(SStockOperationTypeEnum typeEnum) {
        if (typeEnum == null) return false;
        return id.equals(typeEnum.getId());
    }

    public boolean equals(Integer id) {
        if (id == null) return false;
        return this.id.equals(id);
    }

    public static SStockOperationTypeEnum getEnumByCode(Integer id) {
        for (SStockOperationTypeEnum e : SStockOperationTypeEnum.values()) {
            if (e.id == id) {
                return e;
            }
        }
        return null;
    }

}
