package com.thebeastshop.stock.enums;

import java.util.LinkedList;
import java.util.List;

/**
 * t_wh_inv_occupy表OCCUPY_TYPE字段 占用类型 
 * @author donghui
 */
public enum SStockOccupyTypeEnum {
    ALLOT_OUT(20, "调拨出库", SStockOperationTypeEnum.DEFAULT),
    ALLOT_PRE_OCCUPY(42, "调拨预占用", SStockOperationTypeEnum.DEFAULT),
    PURCHASE_OUT(21, "采购出库", SStockOperationTypeEnum.DEFAULT),
    SALES_OUT(22, "销售出库", SStockOperationTypeEnum.DEFAULT),
    GIFT_OUT(23, "礼品出库", SStockOperationTypeEnum.DEFAULT),
    SAMPLE_OUT( 24, "样品出库", SStockOperationTypeEnum.DEFAULT),
    CHANGE_OUT(25, "换货出库", SStockOperationTypeEnum.DEFAULT),
    PRODUCE_OUT(27, "生产加工出库", SStockOperationTypeEnum.DEFAULT),
	  PURCHASE_RETURN_OUT(28, "采退出库", SStockOperationTypeEnum.DEFAULT),
	  TYPE_MOVE_OUT(29,"库间移出", SStockOperationTypeEnum.DEFAULT),
	  ALLOT_OCCUPY(30, "调拨库存占用", SStockOperationTypeEnum.DEFAULT),
	  CAMPAIGN_OUT(35, "活动占用", SStockOperationTypeEnum.PREPARED),
    INTEREST(36, "权益服务占用", SStockOperationTypeEnum.PREPARED),
	GROUP_BUY_DEFAULT(40, "默认拼团占用", SStockOperationTypeEnum.GROUP_BUY),
	  GROUP_BUY_PRESALE(41, "预售拼团占用", SStockOperationTypeEnum.GROUP_BUY),
    RETURN_ON_THE_WAY(1, "退货在途", SStockOperationTypeEnum.DEFAULT),
    PLAN_ON_THE_WAY(2, "采购在途", SStockOperationTypeEnum.DEFAULT),
    ALLOT_ON_THE_WAY(3, "调拨在途", SStockOperationTypeEnum.DEFAULT),
    JOB_ON_THE_WAY(4, "加工在途", SStockOperationTypeEnum.DEFAULT),
    GRADE_ADJUST_OUT(37, "品级调整占用", SStockOperationTypeEnum.DEFAULT),
	INTEREST_PRESALE(39, "权益预售占用", SStockOperationTypeEnum.PREPARED),

	QT(0, "其它占用", SStockOperationTypeEnum.DEFAULT);

	private Integer code;
	private String name;
	private SStockOperationTypeEnum releaseOperationType;


	SStockOccupyTypeEnum(Integer code, String name, SStockOperationTypeEnum releaseOperationType) {
		this.code = code;
		this.name = name;
		this.releaseOperationType = releaseOperationType;
	}

	public static SStockOccupyTypeEnum getEnumByCode(Integer code) {
		for (SStockOccupyTypeEnum e : SStockOccupyTypeEnum.values()) {
			if (e.code == code) {
				return e;
			}
		}
		return null;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public SStockOperationTypeEnum getReleaseOperationType() {
		return releaseOperationType;
	}

	public void setReleaseOperationType(SStockOperationTypeEnum releaseOperationType) {
		this.releaseOperationType = releaseOperationType;
	}

	public Boolean equals(SStockOccupyTypeEnum other) {
		if (other == null || code == null) return false;
		return code.equals(other.getCode());
	}


	public Boolean equals(Integer code) {
		if (this.code == null || code == null) return false;
		return this.code.equals(code);
	}

	/**
	 * 获取所有预备库存占用类型
	 * @return
     */
	public static List<SStockOccupyTypeEnum> getPreparedOccupyTypeList() {
		List<SStockOccupyTypeEnum> results = new LinkedList<>();
		SStockOccupyTypeEnum values[] = values();
		for (SStockOccupyTypeEnum occupyTypeEnum : values) {
			if (SStockOperationTypeEnum.PREPARED.equals(occupyTypeEnum.releaseOperationType)) {
				results.add(occupyTypeEnum);
			}
		}
		return results;
	}

}
