package com.thebeastshop.stock.vo;

import com.thebeastshop.stock.enums.SVirtualStockType;

/**
 * 锁现货库存的结果VO类
 * <p>封装根据预售虚拟库存锁现货库存的结果</p>
 *
 * @author gongjun
 */
public class SLockSpotStockResultVO {

    /**
     * 预售虚拟库存ID
     */
    private Long virtualStockId;

    /**
     * 预售ID
     */
    private Long presaleId;

    /**
     * 库存类型 (如：权益库存)
     */
    private SVirtualStockType stockType;

    /**
     * SKU编号
     */
    private String skuCode;

    /**
     * 业务编号（如：权益号）
     */
    private String businessCode;

    /**
     * 占用数量
     */
    private Integer quantity;

    public Long getVirtualStockId() {
        return virtualStockId;
    }

    public void setVirtualStockId(Long virtualStockId) {
        this.virtualStockId = virtualStockId;
    }

    public Long getPresaleId() {
        return presaleId;
    }

    public void setPresaleId(Long presaleId) {
        this.presaleId = presaleId;
    }

    public SVirtualStockType getStockType() {
        return stockType;
    }

    public void setStockType(SVirtualStockType stockType) {
        this.stockType = stockType;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }
}
