package com.thebeastshop.stock.service;

import java.util.List;
import java.util.Map;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.stock.dto.SGroupbuyCheckDTO;
import com.thebeastshop.stock.dto.SGroupbuyOwnerOccupyDTO;
import com.thebeastshop.stock.dto.SGroupbuyParterOccupyDTO;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import com.thebeastshop.stock.vo.SGroupbuyCheckResultVO;
import com.thebeastshop.stock.vo.SGroupbuyStockVO;

public interface SGroupbuyStockService {
	
	SGroupbuyCheckResultVO checkCanStartGroupbuy(SGroupbuyCheckDTO dto);

	SGroupbuyCheckResultVO checkCanJoinGroupbuy(SGroupbuyCheckDTO dto);
	
	List<SGroupbuyStockVO> getGroupbuyStock(List<String> skuCodeList);

	List<SGroupbuyStockVO> getGroupbuyStockByGroupbuyId(String groupbuyId, List<String> skuCodeList);
	
	ServiceResp<?> groupbuyOwnerOccupy(SGroupbuyOwnerOccupyDTO dto);
	
	ServiceResp<?> groupbuyParternerOccupy(SGroupbuyParterOccupyDTO dto);

	/**
	 * 团长未付款取消（未开团不需要返还活动限量）
	 *
	 * @param groupBuyId
	 * @return
	 */
	ServiceResp<Boolean> releaseUnpaidGroupBuyOccupation(String groupBuyId);

	/**
	 * 拼团超时取消
	 * @param groupBuyId
	 * @releaseOrderOccupationList 订单占用记录
	 * @return
	 */
	ServiceResp<Boolean> cancelGroupBuyOccupation(String groupBuyId, List<SStockReleaseDTO> releaseOrderOccupationList);

	Map<String, Boolean> checkSkuRelatedGroupbuy(List<String> skuCodes);
	
	List<String> getSkuCodeListByGroupbuyId(String groupbuyId);
}
